/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.MessageTemplateProvider;
import com.powsybl.commons.report.ReportNodeAdderOrBuilder;
import com.powsybl.commons.report.TreeContext;
import com.powsybl.commons.report.TypedValue;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractReportNodeAdderOrBuilder<T extends ReportNodeAdderOrBuilder<T>>
implements ReportNodeAdderOrBuilder<T> {
    protected final Map<String, TypedValue> values = new LinkedHashMap<String, TypedValue>();
    protected String key;
    protected String messageTemplate;
    protected boolean withTimestamp = false;
    protected String timestampPattern;
    protected MessageTemplateProvider messageTemplateProvider = MessageTemplateProvider.EMPTY;

    @Override
    public T withMessageTemplateProvider(MessageTemplateProvider messageTemplateProvider) {
        this.messageTemplateProvider = Objects.requireNonNull(messageTemplateProvider);
        return this.self();
    }

    @Override
    public T withMessageTemplate(String key, String messageTemplate) {
        this.key = key;
        this.messageTemplate = messageTemplate;
        return this.self();
    }

    @Override
    public T withMessageTemplate(String key) {
        this.key = key;
        return this.self();
    }

    @Override
    public T withTypedValue(String key, String value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, String value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withTypedValue(String key, double value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, double value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withTypedValue(String key, float value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, float value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withTypedValue(String key, int value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, int value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withTypedValue(String key, long value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, long value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withTypedValue(String key, boolean value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, boolean value) {
        this.values.put(key, TypedValue.untyped(value));
        return this.self();
    }

    @Override
    public T withSeverity(TypedValue severity) {
        TypedValue.checkSeverityType(severity);
        this.values.put("reportSeverity", severity);
        return this.self();
    }

    @Override
    public T withSeverity(String severity) {
        this.values.put("reportSeverity", TypedValue.of(severity, "SEVERITY"));
        return this.self();
    }

    @Override
    public T withTimestamp() {
        this.withTimestamp = true;
        return this.self();
    }

    @Override
    public T withTimestamp(String pattern) {
        this.withTimestamp = true;
        this.timestampPattern = Objects.requireNonNull(pattern);
        return this.self();
    }

    protected void updateTreeDictionary(TreeContext treeContext) {
        if (this.messageTemplate == null) {
            treeContext.addDictionaryEntry(this.key, this.messageTemplateProvider);
        } else {
            treeContext.addDictionaryEntry(this.key, (k, l) -> this.messageTemplate);
        }
    }

    protected void addTimeStampValue(TreeContext treeContext) {
        DateTimeFormatter formatter = this.timestampPattern != null ? DateTimeFormatter.ofPattern(this.timestampPattern, treeContext.getLocale()) : treeContext.getDefaultTimestampFormatter();
        this.values.put("reportTimestamp", TypedValue.getTimestamp(formatter));
    }

    protected abstract T self();
}

