/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.MessageTemplateProvider;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MultiBundleMessageTemplateProvider
implements MessageTemplateProvider {
    private final String[] bundleBaseNames;
    private final boolean throwIfUnknownKey;

    public MultiBundleMessageTemplateProvider(String ... bundleBaseNames) {
        this(false, bundleBaseNames);
    }

    public MultiBundleMessageTemplateProvider(boolean throwIfUnknownKey, String ... bundleBaseNames) {
        this.bundleBaseNames = bundleBaseNames;
        this.throwIfUnknownKey = throwIfUnknownKey;
    }

    @Override
    public String getTemplate(String key, Locale locale) {
        for (String bundleBaseName : this.bundleBaseNames) {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleBaseName, locale);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        if (this.throwIfUnknownKey) {
            throw new MissingResourceException("Could not find template for key '{}'", PropertyResourceBundle.class.getName(), key);
        }
        return MessageTemplateProvider.getMissingKeyMessage(key, locale);
    }
}

