/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class TypedValue {
    public static final String UNTYPED_TYPE = "UNTYPED";
    public static final String SEVERITY = "SEVERITY";
    public static final String ACTIVE_POWER = "ACTIVE_POWER";
    public static final String REACTIVE_POWER = "REACTIVE_POWER";
    public static final String RESISTANCE = "RESISTANCE";
    public static final String REACTANCE = "REACTANCE";
    public static final String IMPEDANCE = "IMPEDANCE";
    public static final String SUSCEPTANCE = "SUSCEPTANCE";
    public static final String VOLTAGE = "VOLTAGE";
    public static final String ANGLE = "ANGLE";
    public static final String SUBSTATION = "SUBSTATION";
    public static final String VOLTAGE_LEVEL = "VOLTAGE_LEVEL";
    public static final String FILENAME = "FILENAME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String URN_UUID = "URN_UUID";
    public static final String CGMES_SUBSET = "CGMES_SUBSET";
    public static final String ID = "ID";
    public static final TypedValue TRACE_SEVERITY = TypedValue.of("TRACE", "SEVERITY");
    public static final TypedValue DEBUG_SEVERITY = TypedValue.of("DEBUG", "SEVERITY");
    public static final TypedValue INFO_SEVERITY = TypedValue.of("INFO", "SEVERITY");
    public static final TypedValue WARN_SEVERITY = TypedValue.of("WARN", "SEVERITY");
    public static final TypedValue ERROR_SEVERITY = TypedValue.of("ERROR", "SEVERITY");
    public static final TypedValue DETAIL_SEVERITY = TypedValue.of("DETAIL", "SEVERITY");
    private final Object value;
    private final String type;

    public static TypedValue of(int value, String type) {
        return new TypedValue(value, type);
    }

    public static TypedValue of(long value, String type) {
        return new TypedValue(value, type);
    }

    public static TypedValue of(float value, String type) {
        return new TypedValue(Float.valueOf(value), type);
    }

    public static TypedValue of(double value, String type) {
        return new TypedValue(value, type);
    }

    public static TypedValue of(boolean value, String type) {
        return new TypedValue(value, type);
    }

    public static TypedValue of(String value, String type) {
        return new TypedValue(value, type);
    }

    public static TypedValue untyped(int value) {
        return new TypedValue(value, UNTYPED_TYPE);
    }

    public static TypedValue untyped(long value) {
        return new TypedValue(value, UNTYPED_TYPE);
    }

    public static TypedValue untyped(float value) {
        return new TypedValue(Float.valueOf(value), UNTYPED_TYPE);
    }

    public static TypedValue untyped(double value) {
        return new TypedValue(value, UNTYPED_TYPE);
    }

    public static TypedValue untyped(boolean value) {
        return new TypedValue(value, UNTYPED_TYPE);
    }

    public static TypedValue untyped(String value) {
        return new TypedValue(value, UNTYPED_TYPE);
    }

    TypedValue(Object value, String type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypedValue getTimestamp(DateTimeFormatter timestampFormatter) {
        return TypedValue.of(timestampFormatter.format(ZonedDateTime.now()), TIMESTAMP);
    }

    static void checkSeverityType(TypedValue severity) {
        if (!severity.getType().equals(SEVERITY)) {
            throw new IllegalArgumentException("Expected a SEVERITY but received " + severity.getType());
        }
    }
}

