/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.xml;

import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.AbstractTreeDataReader;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.xml.XmlUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlReader
extends AbstractTreeDataReader {
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLInputFactory::newInstance);
    private final XMLStreamReader reader;
    private final Map<String, String> namespaceVersionsMap;
    private final Collection<ExtensionSerDe> extensionProviders;

    public XmlReader(InputStream is, Map<String, String> namespaceVersionMap, Collection<ExtensionSerDe> extensionProviders) throws XMLStreamException {
        this.reader = XML_INPUT_FACTORY_SUPPLIER.get().createXMLStreamReader(Objects.requireNonNull(is));
        int state = this.reader.next();
        while (state == 5) {
            state = this.reader.next();
        }
        this.namespaceVersionsMap = Objects.requireNonNull(namespaceVersionMap);
        this.extensionProviders = Objects.requireNonNull(extensionProviders);
    }

    @Override
    public String readRootVersion() {
        return this.namespaceVersionsMap.get(this.reader.getNamespaceURI());
    }

    @Override
    public Map<String, String> readExtensionVersions() {
        int namespaceCount = this.reader.getNamespaceCount();
        List<String> namespaceUris = IntStream.range(0, namespaceCount).boxed().map(this.reader::getNamespaceURI).toList();
        HashMap<String, String> versions = new HashMap<String, String>();
        for (ExtensionSerDe e : this.extensionProviders) {
            e.getNamespaceUriStream().filter(namespaceUris::contains).findFirst().ifPresent(uri -> versions.put(e.getExtensionName(), e.getVersion((String)uri)));
        }
        return versions;
    }

    @Override
    public double readDoubleAttribute(String name, double defaultValue) {
        return XmlUtil.readDoubleAttribute(this.reader, name, defaultValue);
    }

    @Override
    public OptionalDouble readOptionalDoubleAttribute(String name) {
        return XmlUtil.readOptionalDoubleAttribute(this.reader, name);
    }

    @Override
    public float readFloatAttribute(String name, float defaultValue) {
        return XmlUtil.readFloatAttribute(this.reader, name, defaultValue);
    }

    @Override
    public String readStringAttribute(String name) {
        return this.reader.getAttributeValue(null, name);
    }

    @Override
    public int readIntAttribute(String name) {
        Integer value = XmlUtil.readIntegerAttribute(this.reader, name);
        if (value == null) {
            throw new PowsyblException("XML parsing: cannot find required attribute '" + name + "'");
        }
        return value;
    }

    @Override
    public OptionalInt readOptionalIntAttribute(String name) {
        return XmlUtil.readOptionalIntegerAttribute(this.reader, name);
    }

    @Override
    public int readIntAttribute(String name, int defaultValue) {
        return XmlUtil.readIntAttribute(this.reader, name, defaultValue);
    }

    @Override
    public boolean readBooleanAttribute(String name) {
        Boolean value = XmlUtil.readBooleanAttribute(this.reader, name);
        if (value == null) {
            throw new PowsyblException("XML parsing: cannot find required attribute '" + name + "'");
        }
        return value;
    }

    @Override
    public boolean readBooleanAttribute(String name, boolean defaultValue) {
        return XmlUtil.readBooleanAttribute(this.reader, name, defaultValue);
    }

    @Override
    public Optional<Boolean> readOptionalBooleanAttribute(String name) {
        return Optional.ofNullable(XmlUtil.readBooleanAttribute(this.reader, name));
    }

    @Override
    public String readContent() {
        try {
            return XmlUtil.readText(this.reader);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    @Override
    public List<Integer> readIntArrayAttribute(String name) {
        return Arrays.stream(this.readAndSplitStringArray(name)).map(Integer::parseInt).toList();
    }

    @Override
    public List<String> readStringArrayAttribute(String name) {
        return Arrays.asList(this.readAndSplitStringArray(name));
    }

    private String[] readAndSplitStringArray(String name) {
        String arrayString = this.readStringAttribute(name);
        if (arrayString == null) {
            return new String[0];
        }
        return arrayString.split(",");
    }

    @Override
    public void readChildNodes(TreeDataReader.ChildNodeReader childNodeReader) {
        XmlUtil.readSubElements(this.reader, childNodeReader);
    }

    @Override
    public void skipNode() {
        this.readChildNodes(elementName -> this.skipNode());
    }

    @Override
    public void readEndNode() {
        try {
            XmlUtil.readEndElementOrThrow(this.reader);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
            XmlUtil.gcXmlInputFactory(XML_INPUT_FACTORY_SUPPLIER.get());
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }
}

