/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.compress;

import com.powsybl.commons.io.ForwardingInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SafeZipInputStream
extends ForwardingInputStream<ZipInputStream> {
    private long bytesRead;
    private int entriesRead;
    private final long maxBytesToRead;
    private final int maxEntriesToRead;

    public SafeZipInputStream(ZipInputStream in, int maxEntriesToRead, long maxBytesToRead) {
        super(in);
        this.maxEntriesToRead = maxEntriesToRead;
        this.maxBytesToRead = maxBytesToRead;
    }

    public ZipEntry getNextEntry() throws IOException {
        if (++this.entriesRead > this.maxEntriesToRead) {
            throw new IOException("Max entries to read exceeded");
        }
        return ((ZipInputStream)this.getDelegate()).getNextEntry();
    }

    @Override
    public int read() throws IOException {
        int byteRead = super.read();
        if (byteRead != -1 && ++this.bytesRead > this.maxBytesToRead) {
            throw new IOException("Max bytes to read exceeded");
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int byteRead = super.read(b, off, len);
        if (byteRead != -1) {
            this.bytesRead += (long)byteRead;
            if (this.bytesRead > this.maxBytesToRead) {
                throw new IOException("Max bytes to read exceeded");
            }
        }
        return byteRead;
    }
}

