/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

abstract class AbstractFileSystemDataSource
implements DataSource {
    final Path directory;
    final String baseName;
    final String dataExtension;
    final CompressionFormat compressionFormat;
    final DataSourceObserver observer;

    AbstractFileSystemDataSource(Path directory, String baseName, String dataExtension, CompressionFormat compressionFormat, DataSourceObserver observer) {
        this.directory = Objects.requireNonNull(directory);
        this.baseName = Objects.requireNonNull(baseName);
        this.dataExtension = dataExtension;
        this.compressionFormat = compressionFormat;
        this.observer = observer;
    }

    @Override
    public boolean isDataExtension(String ext) {
        return this.dataExtension == null || this.dataExtension.isEmpty() || this.dataExtension.equals(ext);
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getDataExtension() {
        return this.dataExtension;
    }

    public CompressionFormat getCompressionFormat() {
        return this.compressionFormat;
    }

    String getCompressionExtension() {
        return this.compressionFormat == null ? "" : "." + this.compressionFormat.getExtension();
    }

    public DataSourceObserver getObserver() {
        return this.observer;
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        return this.exists(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }
}

