/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakListenerList<L> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeakListenerList.class);
    private final WeakHashMap<L, Object> listeners = new WeakHashMap();
    private final Lock lock = new ReentrantLock();

    public int size() {
        return this.listeners.size();
    }

    public void add(L l) {
        Objects.requireNonNull(l);
        this.lock.lock();
        try {
            this.listeners.put(l, new Object());
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean remove(L l) {
        Objects.requireNonNull(l);
        this.lock.lock();
        try {
            boolean bl = this.listeners.remove(l) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeAll() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notify(Consumer<L> notifier) {
        HashSet cachedListeners;
        Objects.requireNonNull(notifier);
        this.lock.lock();
        try {
            cachedListeners = this.listeners.keySet().stream().map(WeakReference::new).collect(Collectors.toCollection(HashSet::new));
        }
        finally {
            this.lock.unlock();
        }
        for (WeakReference listenerRef : cachedListeners) {
            Object listener = listenerRef.get();
            if (listener == null) continue;
            notifier.accept(listener);
        }
    }

    public List<L> toList() {
        this.lock.lock();
        try {
            ArrayList<L> arrayList = new ArrayList<L>(this.listeners.keySet());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void log() {
        this.lock.lock();
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Weak listener list status:{}{}", (Object)System.lineSeparator(), (Object)new HashSet<L>(this.listeners.keySet()).stream().collect(Collectors.groupingBy(Object::getClass)).entrySet().stream().map(e -> ((Class)e.getKey()).getSimpleName() + ": " + ((List)e.getValue()).size()).collect(Collectors.joining(System.lineSeparator())));
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

