/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.DefaultExtensionProvidersLoader;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.extensions.ExtensionProvidersLoader;
import com.powsybl.commons.extensions.ExtensionSerDe;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionProviders<T extends ExtensionProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionProviders.class);
    private final Map<String, T> providers;

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz) {
        return new ExtensionProviders<T>(clazz);
    }

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz, String categoryName) {
        return new ExtensionProviders<T>(clazz, categoryName);
    }

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz, String categoryName, ExtensionProvidersLoader loader) {
        return new ExtensionProviders<T>(clazz, categoryName, null, loader);
    }

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz, String categoryName, Set<String> extensionNames) {
        return new ExtensionProviders<T>(clazz, categoryName, extensionNames);
    }

    private ExtensionProviders(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        this.providers = this.loadProviders(clazz, null, null, new DefaultExtensionProvidersLoader());
    }

    private ExtensionProviders(Class<T> clazz, String categoryName) {
        this(clazz, categoryName, null);
    }

    private ExtensionProviders(Class<T> clazz, String categoryName, Set<String> extensionNames) {
        this(clazz, categoryName, extensionNames, new DefaultExtensionProvidersLoader());
    }

    private ExtensionProviders(Class<T> clazz, String categoryName, Set<String> extensionNames, ExtensionProvidersLoader loader) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(categoryName);
        this.providers = this.loadProviders(clazz, categoryName, extensionNames, loader);
    }

    private Map<String, T> loadProviders(Class<T> clazz, String categoryName, Set<String> extensionNames, ExtensionProvidersLoader loader) {
        HashMap providersMap = new HashMap();
        Stream servicesStream = loader.getServicesStream(clazz);
        if (categoryName != null) {
            servicesStream = servicesStream.filter(s -> s.getCategoryName().equals(categoryName));
        }
        Set<ExtensionProvider> services = servicesStream.collect(Collectors.toSet());
        services.forEach(service -> this.addService(providersMap, service, extensionNames));
        if (clazz.equals(ExtensionSerDe.class)) {
            services.forEach(service -> ((ExtensionSerDe)service).getSerializationNames().stream().filter(name -> !service.getExtensionName().equals(name)).forEach(name -> this.addServiceForAlternativeName(providersMap, (T)service, (String)name, extensionNames)));
        }
        return providersMap;
    }

    private void addService(Map<String, T> providersMap, T service, Set<String> extensionsToImport) {
        String name = service.getExtensionName();
        if (extensionsToImport == null || extensionsToImport.contains(name)) {
            if (providersMap.containsKey(name)) {
                throw new IllegalStateException("Several providers were found for extension '" + name + "'");
            }
            providersMap.put(name, service);
        }
    }

    private void addServiceForAlternativeName(Map<String, T> providersMap, T service, String alternativeName, Set<String> extensionsToImport) {
        if (extensionsToImport == null || extensionsToImport.contains(service.getExtensionName()) || extensionsToImport.contains(alternativeName)) {
            ExtensionProvider previousService = (ExtensionProvider)providersMap.get(alternativeName);
            if (previousService != null) {
                LOGGER.warn("Alternative extension name {} for extension {} is already used for real extension {} - Skipping", new Object[]{alternativeName, service.getExtensionName(), previousService.getExtensionName()});
            } else {
                providersMap.put(alternativeName, service);
            }
        }
    }

    public T findProvider(String name) {
        return (T)((ExtensionProvider)this.providers.get(name));
    }

    public T findProviderOrThrowException(String name) {
        T serializer = this.findProvider(name);
        if (serializer == null) {
            throw new PowsyblException("Provider not found for extension " + name);
        }
        return serializer;
    }

    public Collection<T> getProviders() {
        return this.providers.values().stream().distinct().collect(Collectors.toList());
    }

    public <E> void addExtensions(Extendable<E> extendable, Collection<Extension<E>> extensions) {
        Objects.requireNonNull(extendable);
        Objects.requireNonNull(extensions);
        extensions.forEach(e -> extendable.addExtension(this.findProvider(e.getName()).getExtensionClass(), e));
    }
}

