/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.MessageTemplateProvider;
import com.powsybl.commons.report.ReportConstants;
import java.util.Locale;
import java.util.ResourceBundle;

public class BundleMessageTemplateProvider
implements MessageTemplateProvider {
    private final String bundleBaseName;
    private final boolean throwIfUnknownKey;
    private ResourceBundle resourceBundle;

    public BundleMessageTemplateProvider(String bundleBaseName) {
        this(bundleBaseName, false);
    }

    public BundleMessageTemplateProvider(String bundleBaseName, boolean throwIfUnknownKey) {
        this.bundleBaseName = bundleBaseName;
        this.resourceBundle = ResourceBundle.getBundle(bundleBaseName, ReportConstants.DEFAULT_LOCALE);
        this.throwIfUnknownKey = throwIfUnknownKey;
    }

    @Override
    public String getTemplate(String key, Locale locale) {
        if (!this.resourceBundle.getLocale().equals(locale)) {
            this.resourceBundle = ResourceBundle.getBundle(this.bundleBaseName, locale);
        }
        if (!this.throwIfUnknownKey && !this.resourceBundle.containsKey(key)) {
            return MessageTemplateProvider.getMissingKeyMessage(key, locale);
        }
        return this.resourceBundle.getString(key);
    }
}

