/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.google.common.io.ByteStreams;
import com.google.re2j.Pattern;
import com.powsybl.commons.datasource.AbstractArchiveDataSource;
import com.powsybl.commons.datasource.ArchiveFormat;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileInformation;
import com.powsybl.commons.datasource.ObservableInputStream;
import com.powsybl.commons.datasource.ObservableOutputStream;
import com.powsybl.commons.io.ForwardingInputStream;
import com.powsybl.commons.io.ForwardingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;

public class TarArchiveDataSource
extends AbstractArchiveDataSource {
    public TarArchiveDataSource(Path directory, String tarFileName, String baseName, String dataExtension, CompressionFormat compressionFormat, DataSourceObserver observer) {
        super(directory, tarFileName, baseName, dataExtension, compressionFormat, ArchiveFormat.TAR, observer);
    }

    public TarArchiveDataSource(Path directory, String tarFileName, String baseName, String dataExtension, CompressionFormat compressionFormat) {
        this(directory, tarFileName, baseName, dataExtension, compressionFormat, null);
    }

    public TarArchiveDataSource(Path directory, String baseName, String dataExtension, CompressionFormat compressionFormat, DataSourceObserver observer) {
        this(directory, baseName + (String)(dataExtension == null || dataExtension.isEmpty() ? "" : "." + dataExtension) + ".tar" + (String)(compressionFormat == null ? "" : "." + compressionFormat.getExtension()), baseName, dataExtension, compressionFormat, observer);
    }

    public TarArchiveDataSource(Path directory, String baseName, String dataExtension, CompressionFormat compressionFormat) {
        this(directory, baseName + (String)(dataExtension == null || dataExtension.isEmpty() ? "" : "." + dataExtension) + ".tar" + (String)(compressionFormat == null ? "" : "." + compressionFormat.getExtension()), baseName, dataExtension, compressionFormat, null);
    }

    public TarArchiveDataSource(Path directory, String baseName, CompressionFormat compressionFormat, DataSourceObserver observer) {
        this(directory, baseName + ".tar" + (String)(compressionFormat == null ? "" : "." + compressionFormat.getExtension()), baseName, null, compressionFormat, observer);
    }

    public TarArchiveDataSource(Path directory, String baseName, CompressionFormat compressionFormat) {
        this(directory, baseName + ".tar" + (String)(compressionFormat == null ? "" : "." + compressionFormat.getExtension()), baseName, null, compressionFormat, null);
    }

    public TarArchiveDataSource(Path directory, String baseName) {
        this(directory, baseName + ".tar", baseName, null, null, null);
    }

    public TarArchiveDataSource(Path tarFile) {
        this(tarFile.getParent(), new FileInformation(tarFile.getFileName().toString(), false));
    }

    public TarArchiveDataSource(Path tarFile, DataSourceObserver observer) {
        this(tarFile.getParent(), new FileInformation(tarFile.getFileName().toString(), false), observer);
    }

    private TarArchiveDataSource(Path directory, FileInformation fileInformation) {
        this(directory, fileInformation.getBaseName(), fileInformation.getDataExtension(), fileInformation.getCompressionFormat());
    }

    private TarArchiveDataSource(Path directory, FileInformation fileInformation, DataSourceObserver observer) {
        this(directory, fileInformation.getBaseName(), fileInformation.getDataExtension(), fileInformation.getCompressionFormat(), observer);
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        Pattern p = Pattern.compile((String)regex);
        HashSet<String> names = new HashSet<String>();
        Path tarFilePath = this.getArchiveFilePath();
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(tarFilePath, new OpenOption[0]));
             InputStream cis = TarArchiveDataSource.getCompressedInputStream(inputStream, this.compressionFormat);
             TarArchiveInputStream tar = new TarArchiveInputStream(cis);){
            TarArchiveEntry entry;
            while ((entry = tar.getNextEntry()) != null) {
                if (entry.isDirectory() || !p.matcher((CharSequence)entry.getName()).matches()) continue;
                names.add(entry.getName());
            }
        }
        return names;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean entryExists(Path tarFilePath, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 29[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OutputStream newOutputStream(String suffix, String ext, boolean append) throws IOException {
        return this.newOutputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext), append);
    }

    @Override
    public OutputStream newOutputStream(String fileName, boolean append) throws IOException {
        Objects.requireNonNull(fileName);
        if (append) {
            throw new UnsupportedOperationException("append not supported in tar file data source");
        }
        Path tarFilePath = this.getArchiveFilePath();
        TarEntryOutputStream os = new TarEntryOutputStream(tarFilePath, fileName, this.compressionFormat);
        return this.observer != null ? new ObservableOutputStream(os, tarFilePath + ":" + fileName, this.observer) : os;
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        Objects.requireNonNull(fileName);
        Path tarFilePath = this.getArchiveFilePath();
        if (this.entryExists(tarFilePath, fileName)) {
            TarEntryInputStream is = new TarEntryInputStream(tarFilePath, fileName, this.compressionFormat);
            return this.observer != null ? new ObservableInputStream(is, tarFilePath + ":" + fileName, this.observer) : is;
        }
        return null;
    }

    private static InputStream getCompressedInputStream(InputStream is, CompressionFormat compressionFormat) throws IOException {
        if (compressionFormat == null) {
            return is;
        }
        return switch (compressionFormat) {
            case CompressionFormat.GZIP -> new GzipCompressorInputStream(is);
            case CompressionFormat.BZIP2 -> new BZip2CompressorInputStream(is);
            case CompressionFormat.XZ -> new XZCompressorInputStream(is);
            case CompressionFormat.ZSTD -> new ZstdCompressorInputStream(is);
            default -> is;
        };
    }

    private static final class TarEntryOutputStream
    extends ForwardingOutputStream<OutputStream> {
        private final Path tarFilePath;
        private final String fileName;
        private final CompressionFormat compressionFormat;
        private boolean closed;

        private TarEntryOutputStream(Path tarFilePath, String fileName, CompressionFormat compressionFormat) throws IOException {
            super(TarEntryOutputStream.getTmpStream(TarEntryOutputStream.getTmpStreamFilePath(tarFilePath)));
            this.tarFilePath = tarFilePath;
            this.fileName = fileName;
            this.compressionFormat = compressionFormat;
            this.closed = false;
        }

        private static OutputStream getTmpStream(Path tarFilePath) throws IOException {
            return new BufferedOutputStream(Files.newOutputStream(tarFilePath, new OpenOption[0]));
        }

        private static Path getTmpStreamFilePath(Path tarFilePath) {
            return tarFilePath.getParent().resolve("tmp_stream_" + tarFilePath.getFileName() + ".stream");
        }

        private static TarArchiveOutputStream getTarStream(Path tmpTarFilePath) throws IOException {
            return new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(tmpTarFilePath, new OpenOption[0])));
        }

        private static Path getTmpTarFilePath(Path tarFilePath) {
            return tarFilePath.getParent().resolve("tmp_" + tarFilePath.getFileName());
        }

        private static Path getTmpCompressedTarFilePath(Path tarFilePath) {
            return tarFilePath.getParent().resolve("tmp_comp_" + tarFilePath.getFileName());
        }

        private void compressTarFile() throws IOException {
            try (InputStream fis = Files.newInputStream(TarEntryOutputStream.getTmpTarFilePath(this.tarFilePath), new OpenOption[0]);
                 OutputStream fos = Files.newOutputStream(TarEntryOutputStream.getTmpCompressedTarFilePath(this.tarFilePath), StandardOpenOption.CREATE);
                 OutputStream compressedOS = TarEntryOutputStream.getCompressedOutputStream(fos, this.compressionFormat);){
                int len;
                byte[] buffer = new byte[8192];
                while ((len = fis.read(buffer)) != -1) {
                    compressedOS.write(buffer, 0, len);
                }
            }
        }

        private static OutputStream getCompressedOutputStream(OutputStream os, CompressionFormat compressionFormat) throws IOException {
            OutputStream outputStream;
            if (compressionFormat == null) {
                outputStream = os;
            } else {
                switch (compressionFormat) {
                    case GZIP: {
                        outputStream = new GzipCompressorOutputStream(os);
                        break;
                    }
                    case BZIP2: {
                        outputStream = new BZip2CompressorOutputStream(os);
                        break;
                    }
                    case XZ: {
                        outputStream = new XZCompressorOutputStream(os);
                        break;
                    }
                    case ZSTD: {
                        outputStream = new ZstdCompressorOutputStream(os);
                        break;
                    }
                    default: {
                        outputStream = os;
                    }
                }
            }
            return outputStream;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                super.close();
                try (TarArchiveOutputStream taos = TarEntryOutputStream.getTarStream(TarEntryOutputStream.getTmpTarFilePath(this.tarFilePath));){
                    taos.setBigNumberMode(2);
                    taos.setLongFileMode(3);
                    Path tmpStreamFilePath = TarEntryOutputStream.getTmpStreamFilePath(this.tarFilePath);
                    try (InputStream is = Files.newInputStream(tmpStreamFilePath, new OpenOption[0]);){
                        TarArchiveEntry entry = new TarArchiveEntry(this.fileName);
                        entry.setSize(Files.size(tmpStreamFilePath));
                        taos.putArchiveEntry(entry);
                        ByteStreams.copy((InputStream)is, (OutputStream)taos);
                        taos.closeArchiveEntry();
                    }
                    if (Files.exists(this.tarFilePath, new LinkOption[0])) {
                        try (InputStream fis = Files.newInputStream(this.tarFilePath, new OpenOption[0]);
                             BufferedInputStream bis = new BufferedInputStream(fis);
                             InputStream cis = TarArchiveDataSource.getCompressedInputStream(bis, this.compressionFormat);
                             TarArchiveInputStream tarInput = new TarArchiveInputStream(cis);){
                            TarArchiveEntry oldEntry;
                            while ((oldEntry = tarInput.getNextEntry()) != null) {
                                int len;
                                if (oldEntry.getName().equals(this.fileName)) continue;
                                taos.putArchiveEntry(oldEntry);
                                byte[] buffer = new byte[8192];
                                while ((len = tarInput.read(buffer)) != -1) {
                                    taos.write(buffer, 0, len);
                                }
                                taos.closeArchiveEntry();
                            }
                        }
                    }
                    taos.finish();
                }
                this.compressTarFile();
                Path tmpTarFilePath = TarEntryOutputStream.getTmpCompressedTarFilePath(this.tarFilePath);
                Files.move(tmpTarFilePath, this.tarFilePath, StandardCopyOption.REPLACE_EXISTING);
                this.closed = true;
            }
        }
    }

    private static final class TarEntryInputStream
    extends ForwardingInputStream<InputStream> {
        private TarEntryInputStream(Path tarFilePath, String fileName, CompressionFormat compressionFormat) throws IOException {
            super(TarEntryInputStream.setStreamToFile(TarEntryInputStream.getTmpStream(tarFilePath, compressionFormat), fileName));
        }

        private static TarArchiveInputStream getTmpStream(Path tarFilePath, CompressionFormat compressionFormat) throws IOException {
            return new TarArchiveInputStream(TarArchiveDataSource.getCompressedInputStream(new BufferedInputStream(Files.newInputStream(tarFilePath, new OpenOption[0])), compressionFormat));
        }

        private static InputStream setStreamToFile(TarArchiveInputStream tais, String fileName) throws IOException {
            TarArchiveEntry entry;
            while ((entry = tais.getNextEntry()) != null) {
                if (!entry.getName().equals(fileName)) continue;
                return tais;
            }
            return null;
        }
    }
}

