/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.MessageTemplateProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class BundleMessageTemplateProvider
implements MessageTemplateProvider {
    private final String bundleBaseName;
    private final boolean throwIfUnknownKey;
    private final Map<Locale, ResourceBundle> resourceBundlesMap = new HashMap<Locale, ResourceBundle>();

    public BundleMessageTemplateProvider(String bundleBaseName) {
        this(bundleBaseName, false);
    }

    public BundleMessageTemplateProvider(String bundleBaseName, boolean throwIfUnknownKey) {
        this.bundleBaseName = bundleBaseName;
        this.throwIfUnknownKey = throwIfUnknownKey;
    }

    @Override
    public String getTemplate(String key, Locale locale) {
        ResourceBundle resourceBundle = this.resourceBundlesMap.computeIfAbsent(locale, l -> ResourceBundle.getBundle(this.bundleBaseName, l, NO_FALLBACK_CONTROL));
        if (!this.throwIfUnknownKey && !resourceBundle.containsKey(key)) {
            return MessageTemplateProvider.getMissingKeyMessage(key, locale);
        }
        return resourceBundle.getString(key);
    }
}

