/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.report.ReportFormatter;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeBuilder;
import com.powsybl.commons.report.ReportNodeNoOp;
import com.powsybl.commons.report.ReportNodeRootBuilderImpl;
import com.powsybl.commons.report.TreeContext;
import com.powsybl.commons.report.TypedValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ReportNode {
    public static final ReportNode NO_OP = new ReportNodeNoOp();

    public static ReportNodeBuilder newRootReportNode() {
        return new ReportNodeRootBuilderImpl();
    }

    public String getMessageKey();

    public String getMessageTemplate();

    default public String getMessage() {
        return this.getMessage(ReportFormatter.DEFAULT);
    }

    public String getMessage(ReportFormatter var1);

    public Map<String, TypedValue> getValues();

    public Optional<TypedValue> getValue(String var1);

    public List<ReportNode> getChildren();

    public ReportNodeAdder newReportNode();

    public TreeContext getTreeContext();

    public void include(ReportNode var1);

    public void addCopy(ReportNode var1);

    public void writeJson(JsonGenerator var1) throws IOException;

    public ReportNode addTypedValue(String var1, String var2, String var3);

    public ReportNode addUntypedValue(String var1, String var2);

    public ReportNode addTypedValue(String var1, double var2, String var4);

    public ReportNode addUntypedValue(String var1, double var2);

    public ReportNode addTypedValue(String var1, float var2, String var3);

    public ReportNode addUntypedValue(String var1, float var2);

    public ReportNode addTypedValue(String var1, int var2, String var3);

    public ReportNode addUntypedValue(String var1, int var2);

    public ReportNode addTypedValue(String var1, long var2, String var4);

    public ReportNode addUntypedValue(String var1, long var2);

    public ReportNode addTypedValue(String var1, boolean var2, String var3);

    public ReportNode addUntypedValue(String var1, boolean var2);

    public ReportNode addSeverity(TypedValue var1);

    public ReportNode addSeverity(String var1);

    default public void print(Path path) throws IOException {
        this.print(path, ReportFormatter.DEFAULT);
    }

    default public void print(Path path, ReportFormatter formatter) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.print(writer, formatter);
        }
    }

    default public void print(Writer writer) throws IOException {
        this.print(writer, ReportFormatter.DEFAULT);
    }

    public void print(Writer var1, ReportFormatter var2) throws IOException;
}

