/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.commons.ref.RefObj;
import com.powsybl.commons.report.MessageTemplateProvider;
import com.powsybl.commons.report.ReportFormatter;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeChildAdderImpl;
import com.powsybl.commons.report.ReportNodeDeserializer;
import com.powsybl.commons.report.ReportNodeJsonModule;
import com.powsybl.commons.report.ReportNodeVersion;
import com.powsybl.commons.report.TreeContext;
import com.powsybl.commons.report.TypedValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;

public final class ReportNodeImpl
implements ReportNode {
    private final String messageKey;
    private final List<ReportNodeImpl> children = new ArrayList<ReportNodeImpl>();
    private final Collection<Map<String, TypedValue>> inheritedValuesMaps;
    private final Map<String, TypedValue> values;
    private final RefChain<TreeContext> treeContext;
    private final MessageTemplateProvider messageTemplateProvider;
    private boolean isRoot;
    private Collection<Map<String, TypedValue>> valuesMapsInheritance;

    static ReportNodeImpl createChildReportNode(String messageKey, Map<String, TypedValue> values, ReportNodeImpl parent, MessageTemplateProvider messageTemplateProvider) {
        ReportNodeImpl child = new ReportNodeImpl(messageKey, values, parent.getValuesMapsInheritance(), parent.getTreeContextRef(), false, messageTemplateProvider);
        parent.addChild(child);
        return child;
    }

    static ReportNodeImpl createRootReportNode(String messageKey, Map<String, TypedValue> values, TreeContext treeContext, MessageTemplateProvider messageTemplateProvider) {
        RefChain<TreeContext> treeContextRef = new RefChain<TreeContext>(new RefObj<TreeContext>(treeContext));
        return new ReportNodeImpl(messageKey, values, Collections.emptyList(), treeContextRef, true, messageTemplateProvider);
    }

    private ReportNodeImpl(String messageKey, Map<String, TypedValue> values, Collection<Map<String, TypedValue>> inheritedValuesMaps, RefChain<TreeContext> treeContext, boolean isRoot, MessageTemplateProvider messageTemplateProvider) {
        this.messageKey = Objects.requireNonNull(messageKey);
        ReportNodeImpl.checkMap(values);
        Objects.requireNonNull(inheritedValuesMaps).forEach(ReportNodeImpl::checkMap);
        this.values = values;
        this.inheritedValuesMaps = inheritedValuesMaps;
        this.treeContext = Objects.requireNonNull(treeContext);
        this.messageTemplateProvider = Objects.requireNonNull(messageTemplateProvider);
        this.isRoot = isRoot;
    }

    private static void checkMap(Map<String, TypedValue> values) {
        Objects.requireNonNull(values).forEach((k, v) -> {
            Objects.requireNonNull(k);
            Objects.requireNonNull(v);
        });
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String getMessageTemplate() {
        return this.getTreeContext().getDictionary().get(this.messageKey);
    }

    @Override
    public Map<String, TypedValue> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public String getMessage(ReportFormatter formatter) {
        return Optional.ofNullable(this.getTreeContext().getDictionary().get(this.messageKey)).map(messageTemplate -> new StringSubstitutor(vk -> this.getValueAsString(vk, formatter).orElse(null)).replace(messageTemplate)).orElse("(missing message key in dictionary)");
    }

    public Optional<String> getValueAsString(String valueKey, ReportFormatter formatter) {
        return this.getValue(valueKey).map(formatter::format);
    }

    @Override
    public TreeContext getTreeContext() {
        return this.getTreeContextRef().get();
    }

    RefChain<TreeContext> getTreeContextRef() {
        return this.treeContext;
    }

    private Collection<Map<String, TypedValue>> getValuesMapsInheritance() {
        if (this.valuesMapsInheritance == null) {
            this.valuesMapsInheritance = new ArrayList<Map<String, TypedValue>>(1 + this.inheritedValuesMaps.size());
            this.valuesMapsInheritance.add(this.values);
            this.valuesMapsInheritance.addAll(this.inheritedValuesMaps);
        }
        return this.valuesMapsInheritance;
    }

    @Override
    public Optional<TypedValue> getValue(String valueKey) {
        return Stream.concat(Stream.of(this.values), this.inheritedValuesMaps.stream()).map(m -> (TypedValue)m.get(valueKey)).filter(Objects::nonNull).findFirst();
    }

    @Override
    public ReportNodeAdder newReportNode() {
        return new ReportNodeChildAdderImpl(this, this.messageTemplateProvider);
    }

    @Override
    public void include(ReportNode reportRoot) {
        if (!(reportRoot instanceof ReportNodeImpl)) {
            throw new PowsyblException("Cannot mix implementations of ReportNode, included reportNode should be/extend ReportNodeImpl");
        }
        ReportNodeImpl reportNodeImpl = (ReportNodeImpl)reportRoot;
        if (!reportNodeImpl.isRoot) {
            throw new PowsyblException("Cannot include non-root reportNode");
        }
        if (this.getTreeContext() == reportNodeImpl.getTreeContext()) {
            throw new PowsyblException("The given reportNode cannot be included as it is the root of the reportNode");
        }
        reportNodeImpl.unroot();
        this.children.add(reportNodeImpl);
        this.getTreeContext().merge(reportNodeImpl.getTreeContext());
        reportNodeImpl.treeContext.setRef(this.treeContext);
    }

    @Override
    public void addCopy(ReportNode reportNode) {
        ObjectMapper om = new ObjectMapper().registerModule((Module)new ReportNodeJsonModule());
        StringWriter sw = new StringWriter();
        try {
            om.writeValue((Writer)sw, (Object)reportNode);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ReportNodeImpl copiedReportNode = (ReportNodeImpl)ReportNodeDeserializer.read(IOUtils.toInputStream((String)sw.toString(), (Charset)StandardCharsets.UTF_8));
        this.children.add(copiedReportNode);
        this.getTreeContext().merge(copiedReportNode.getTreeContext());
        copiedReportNode.treeContext.setRef(this.treeContext);
    }

    private void unroot() {
        this.isRoot = false;
    }

    void addChild(ReportNodeImpl reportNode) {
        this.children.add(reportNode);
    }

    @Override
    public List<ReportNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, String value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, String value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, double value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, double value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, float value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, float value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, int value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, int value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, long value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, long value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addTypedValue(String key, boolean value, String type) {
        this.values.put(key, TypedValue.of(value, type));
        return this;
    }

    @Override
    public ReportNodeImpl addUntypedValue(String key, boolean value) {
        this.values.put(key, TypedValue.untyped(value));
        return this;
    }

    @Override
    public ReportNodeImpl addSeverity(TypedValue severity) {
        TypedValue.checkSeverityType(severity);
        this.values.put("reportSeverity", severity);
        return this;
    }

    @Override
    public ReportNodeImpl addSeverity(String severity) {
        this.values.put("reportSeverity", TypedValue.of(severity, "SEVERITY"));
        return this;
    }

    @Override
    public void print(Writer writer, ReportFormatter formatter) throws IOException {
        this.print(writer, "", formatter);
    }

    private void print(Writer writer, String indentationStart, ReportFormatter formatter) throws IOException {
        if (this.children.isEmpty()) {
            this.print(writer, indentationStart, "", formatter);
        } else {
            this.print(writer, indentationStart, "+ ", formatter);
            String childrenIndent = indentationStart + "   ";
            for (ReportNodeImpl child : this.children) {
                child.print(writer, childrenIndent, formatter);
            }
        }
    }

    private void print(Writer writer, String indent, String prefix, ReportFormatter formatter) throws IOException {
        writer.append(indent).append(prefix).append(this.getMessage(formatter)).append(System.lineSeparator());
    }

    public static ReportNodeImpl parseJsonNode(JsonParser parser, ObjectMapper objectMapper, TreeContext treeContext, ReportNodeVersion version) throws IOException {
        Objects.requireNonNull(version, "ReportNode version is missing (null)");
        Objects.requireNonNull(treeContext);
        switch (version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case V_1_0: 
            case V_2_0: {
                throw new PowsyblException("No backward compatibility of version " + version);
            }
            case V_2_1: 
            case V_3_0: 
        }
        return ReportNodeImpl.parseJsonNode(parser, objectMapper, treeContext);
    }

    private static ReportNodeImpl parseJsonNode(JsonParser parser, ObjectMapper objectMapper, TreeContext treeContext) throws IOException {
        ReportNodeDeserializer.checkToken(parser, JsonToken.START_OBJECT);
        return ReportNodeImpl.parseJsonNode(parser, objectMapper, new RefChain<TreeContext>(new RefObj<TreeContext>(treeContext)), Collections.emptyList(), true);
    }

    private static ReportNodeImpl parseJsonNode(JsonParser p, ObjectMapper objectMapper, RefChain<TreeContext> treeContext, Collection<Map<String, TypedValue>> inheritedValuesMaps, boolean rootReportNode) throws IOException {
        ReportNodeImpl reportNode = null;
        var parsingContext = new Object(){
            String messageKey;
            Map<String, TypedValue> values = Collections.emptyMap();
        };
        block10: while (p.nextToken() != JsonToken.END_OBJECT) {
            switch (p.currentName()) {
                case "messageKey": {
                    parsingContext.messageKey = p.nextTextValue();
                    continue block10;
                }
                case "values": {
                    ReportNodeDeserializer.checkToken(p, JsonToken.START_OBJECT);
                    parsingContext.values = (Map)objectMapper.readValue(p, (TypeReference)new TypeReference<HashMap<String, TypedValue>>(){});
                    continue block10;
                }
                case "children": {
                    reportNode = new ReportNodeImpl(parsingContext.messageKey, parsingContext.values, inheritedValuesMaps, treeContext, rootReportNode, MessageTemplateProvider.EMPTY);
                    ReportNodeDeserializer.checkToken(p, JsonToken.START_ARRAY);
                    while (p.nextToken() != JsonToken.END_ARRAY) {
                        reportNode.addChild(ReportNodeImpl.parseJsonNode(p, objectMapper, treeContext, reportNode.getValuesMapsInheritance(), false));
                    }
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected value: " + p.currentName());
        }
        if (reportNode == null) {
            reportNode = new ReportNodeImpl(parsingContext.messageKey, parsingContext.values, inheritedValuesMaps, treeContext, rootReportNode, MessageTemplateProvider.EMPTY);
        }
        return reportNode;
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeStringField("messageKey", this.getMessageKey());
        if (!this.values.isEmpty()) {
            generator.writeObjectField("values", this.values);
        }
        if (!this.children.isEmpty()) {
            generator.writeFieldName("children");
            generator.writeStartArray();
            for (ReportNodeImpl messageNode : this.children) {
                generator.writeStartObject();
                messageNode.writeJson(generator);
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }
}

