/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.powsybl.commons.PowsyblException;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class StringAnonymizer {
    private static final char DEFAULT_SEPARATOR = ';';
    private final BiMap<String, String> mapping = HashBiMap.create();

    public static String getAlpha(int num) {
        StringBuilder result = new StringBuilder();
        int n = num;
        while (n > 0) {
            int remainder = --n % 26;
            char digit = (char)(remainder + 65);
            result.insert(0, digit);
            n = (n - remainder) / 26;
        }
        return result.toString();
    }

    public int getStringCount() {
        return this.mapping.size();
    }

    public String anonymize(String str) {
        if (str == null) {
            return null;
        }
        return (String)this.mapping.computeIfAbsent((Object)str, k -> StringAnonymizer.getAlpha(this.mapping.size() + 1));
    }

    public String deanonymize(String str) {
        if (str == null) {
            return null;
        }
        String str2 = (String)this.mapping.inverse().get((Object)str);
        if (str2 == null) {
            throw new PowsyblException("Mapping not found for anonymized string '" + str + "'");
        }
        return str2;
    }

    public void readCsv(BufferedReader reader) {
        this.readCsv(reader, ';');
    }

    private static void setFormat(CsvFormat format, char separator) {
        format.setLineSeparator(System.lineSeparator());
        format.setDelimiter(separator);
        format.setQuoteEscape('\"');
    }

    public void readCsv(BufferedReader reader, char separator) {
        CsvParserSettings settings = new CsvParserSettings();
        StringAnonymizer.setFormat((CsvFormat)settings.getFormat(), separator);
        CsvParser csvParser = new CsvParser(settings);
        for (Object[] nextLine : csvParser.iterate((Reader)reader)) {
            if (nextLine.length != 2) {
                throw new PowsyblException("Invalid line '" + Arrays.toString(nextLine) + "'");
            }
            this.mapping.put(nextLine[0], nextLine[1]);
        }
    }

    public void writeCsv(BufferedWriter writer) {
        this.writeCsv(writer, ';');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCsv(BufferedWriter writer, char separator) {
        CsvWriterSettings settings = new CsvWriterSettings();
        StringAnonymizer.setFormat((CsvFormat)settings.getFormat(), separator);
        try (CsvWriter csvWriter = new CsvWriter((Writer)writer, settings);){
            String[] nextLine = new String[2];
            for (Map.Entry e : this.mapping.entrySet()) {
                nextLine[0] = (String)e.getKey();
                nextLine[1] = (String)e.getValue();
                csvWriter.writeRow(nextLine);
            }
        }
    }
}

