/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.AbstractModuleConfig;
import com.powsybl.commons.config.PlatformEnv;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public abstract class AbstractMapModuleConfig
extends AbstractModuleConfig {
    private final FileSystem fs;

    private static PowsyblException createUnexpectedPropertyTypeException(String name, Class<?> type, Class<?>[] expectedTypes) {
        return new PowsyblException("Unexpected value type " + type.getName() + " for property " + name + ", " + Arrays.toString(expectedTypes) + " is expected ");
    }

    private static PowsyblException createPropertyIsNotException(String name, String what, Exception e) {
        return new PowsyblException("Property " + name + " is not " + what, e);
    }

    protected AbstractMapModuleConfig(FileSystem fs) {
        this.fs = Objects.requireNonNull(fs);
    }

    protected abstract Object getValue(String var1);

    @Override
    public Optional<String> getOptionalStringProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{String.class});
        }
        return Optional.of((String)value).map(PlatformEnv::substitute);
    }

    @Override
    public Optional<List<String>> getOptionalStringListProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof String) {
            String val = (String)value;
            String trimmedString = val.trim();
            if (trimmedString.isEmpty()) {
                return Optional.of(Collections.emptyList());
            }
            return Optional.of(Arrays.asList(PlatformEnv.substitute(trimmedString).split("[:,]")));
        }
        if (value instanceof List) {
            return Optional.of(((List)value).stream().map(PlatformEnv::substitute).collect(Collectors.toList()));
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{String.class, List.class});
    }

    @Override
    public OptionalInt getOptionalIntProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return OptionalInt.empty();
        }
        if (value instanceof Integer) {
            return OptionalInt.of((Integer)value);
        }
        if (value instanceof String) {
            String val = (String)value;
            try {
                return OptionalInt.of(Integer.parseInt(val));
            }
            catch (NumberFormatException e) {
                throw AbstractMapModuleConfig.createPropertyIsNotException(name, "an integer", e);
            }
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{String.class, Integer.class});
    }

    @Override
    public OptionalLong getOptionalLongProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return OptionalLong.empty();
        }
        if (value instanceof Long) {
            Long val = (Long)value;
            return OptionalLong.of(val);
        }
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            return OptionalLong.of(val.intValue());
        }
        if (value instanceof String) {
            String val = (String)value;
            try {
                return OptionalLong.of(Long.parseLong(val));
            }
            catch (NumberFormatException e) {
                throw AbstractMapModuleConfig.createPropertyIsNotException(name, "a long", e);
            }
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{String.class, Long.class, Integer.class});
    }

    @Override
    public Optional<Float> getOptionalFloatProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Number) {
            Number val = (Number)value;
            return Optional.of(Float.valueOf(val.floatValue()));
        }
        if (value instanceof String) {
            String val = (String)value;
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(val)));
            }
            catch (NumberFormatException e) {
                throw AbstractMapModuleConfig.createPropertyIsNotException(name, "a float", e);
            }
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{Number.class, String.class});
    }

    @Override
    public OptionalDouble getOptionalDoubleProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return OptionalDouble.empty();
        }
        if (value instanceof Number) {
            Number val = (Number)value;
            return OptionalDouble.of(val.doubleValue());
        }
        if (value instanceof String) {
            String val = (String)value;
            try {
                return OptionalDouble.of(Double.parseDouble(val));
            }
            catch (NumberFormatException e) {
                throw AbstractMapModuleConfig.createPropertyIsNotException(name, "a double", e);
            }
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{Number.class, String.class});
    }

    @Override
    public Optional<Boolean> getOptionalBooleanProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Boolean) {
            Boolean val = (Boolean)value;
            return Optional.of(val);
        }
        if (value instanceof String) {
            String val = (String)value;
            return Optional.of(Boolean.parseBoolean(val));
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{Boolean.class, String.class});
    }

    @Override
    public Optional<ZonedDateTime> getOptionalDateTimeProperty(String name) {
        Objects.requireNonNull(name);
        Object value = this.getValue(name);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return Optional.of(ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
        }
        if (value instanceof String) {
            String val = (String)value;
            try {
                return Optional.of(ZonedDateTime.parse(val));
            }
            catch (IllegalArgumentException e) {
                throw AbstractMapModuleConfig.createPropertyIsNotException(name, "an ISO date time", e);
            }
        }
        throw AbstractMapModuleConfig.createUnexpectedPropertyTypeException(name, value.getClass(), new Class[]{Date.class, String.class});
    }

    @Override
    public Optional<Path> getOptionalPathProperty(String name) {
        return this.getOptionalStringProperty(name).map(x$0 -> this.fs.getPath((String)x$0, new String[0]));
    }

    @Override
    public Optional<List<Path>> getOptionalPathListProperty(String name) {
        return this.getOptionalStringListProperty(name).flatMap(strings -> Optional.of(strings.stream().map(x$0 -> this.fs.getPath((String)x$0, new String[0])).collect(Collectors.toList())));
    }
}

