/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.BaseVoltageConfig;
import com.powsybl.commons.config.PlatformConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class BaseVoltagesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseVoltagesConfig.class);
    private static final String DEFAULT_CONFIG_FILE_NAME = "base-voltages.yml";
    private List<BaseVoltageConfig> baseVoltages = new ArrayList<BaseVoltageConfig>();
    private String defaultProfile;

    public List<BaseVoltageConfig> getBaseVoltages() {
        return this.baseVoltages;
    }

    public void setBaseVoltages(List<BaseVoltageConfig> baseVoltages) {
        this.baseVoltages = baseVoltages == null ? Collections.emptyList() : baseVoltages;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(String defaultProfile) {
        this.defaultProfile = Objects.requireNonNull(defaultProfile);
    }

    public static BaseVoltagesConfig fromPlatformConfig() {
        return BaseVoltagesConfig.fromPlatformConfig(PlatformConfig.defaultConfig());
    }

    public static BaseVoltagesConfig fromPlatformConfig(PlatformConfig platformConfig) {
        return BaseVoltagesConfig.fromPlatformConfig(platformConfig, DEFAULT_CONFIG_FILE_NAME);
    }

    public static BaseVoltagesConfig fromPlatformConfig(PlatformConfig platformConfig, String configFileName) {
        return platformConfig.getConfigDir().map(configDir -> BaseVoltagesConfig.fromPath(configDir, configFileName)).orElseGet(() -> {
            LOGGER.warn("Configuration directory not defined in platform config, trying to load file '{}' from resources", (Object)configFileName);
            return BaseVoltagesConfig.fromResources(configFileName);
        });
    }

    public static BaseVoltagesConfig fromInputStream(InputStream configInputStream) {
        Objects.requireNonNull(configInputStream);
        Yaml yaml = new Yaml((BaseConstructor)new BaseVoltagesConfigConstructor());
        return (BaseVoltagesConfig)yaml.load(configInputStream);
    }

    public static BaseVoltagesConfig fromPath(Path configDir, String configFileName) {
        Objects.requireNonNull(configDir);
        Objects.requireNonNull(configFileName);
        Path configFile = configDir.resolve(configFileName);
        if (Files.exists(configFile, new LinkOption[0])) {
            BaseVoltagesConfig baseVoltagesConfig;
            block9: {
                InputStream configInputStream = Files.newInputStream(configFile, new OpenOption[0]);
                try {
                    baseVoltagesConfig = BaseVoltagesConfig.fromInputStream(configInputStream);
                    if (configInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (configInputStream != null) {
                            try {
                                configInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                configInputStream.close();
            }
            return baseVoltagesConfig;
        }
        LOGGER.warn("Base voltage configuration file '{}' not found, trying to load file '{}' from resources", (Object)configFile, (Object)configFileName);
        return BaseVoltagesConfig.fromResources(configFileName);
    }

    private static BaseVoltagesConfig fromResources(String configFileName) {
        InputStream configInputStream = BaseVoltagesConfig.class.getResourceAsStream("/" + configFileName);
        if (configInputStream != null) {
            return BaseVoltagesConfig.fromInputStream(configInputStream);
        }
        throw new PowsyblException("No base voltages configuration found in resources: " + configFileName);
    }

    public List<String> getProfiles() {
        return this.getBaseVoltages().stream().map(BaseVoltageConfig::getProfile).distinct().collect(Collectors.toList());
    }

    public List<String> getBaseVoltageNames(String profile) {
        Objects.requireNonNull(profile);
        return this.getBaseVoltages().stream().filter(baseVoltage -> baseVoltage.getProfile().equals(profile)).map(BaseVoltageConfig::getName).collect(Collectors.toList());
    }

    public Optional<String> getBaseVoltageName(double baseVoltage, String profile) {
        Objects.requireNonNull(profile);
        return this.getBaseVoltages().stream().filter(v -> v.getProfile().equals(profile) && v.getMinValue() <= baseVoltage && v.getMaxValue() > baseVoltage).map(BaseVoltageConfig::getName).findFirst();
    }

    private static class BaseVoltagesConfigConstructor
    extends Constructor {
        private static final List<String> BASE_VOLTAGES_CONFIG_REQUIRED_FIELDS = Arrays.asList("baseVoltages", "defaultProfile");
        private static final List<String> BASE_VOLTAGE_CONFIG_REQUIRED_FIELDS = Arrays.asList("name", "minValue", "maxValue", "profile");

        BaseVoltagesConfigConstructor() {
            super(BaseVoltagesConfig.class, new LoaderOptions());
        }

        protected Object constructObject(Node node) {
            if (node.getTag().equals((Object)this.rootTag)) {
                this.checkRequiredFields(node, new LinkedList<String>(BASE_VOLTAGES_CONFIG_REQUIRED_FIELDS), BaseVoltagesConfig.class);
            } else if (node.getType().equals(BaseVoltageConfig.class)) {
                this.checkRequiredFields(node, new LinkedList<String>(BASE_VOLTAGE_CONFIG_REQUIRED_FIELDS), node.getType());
            }
            return super.constructObject(node);
        }

        private void checkRequiredFields(Node node, List<String> requiredFields, Class<?> aClass) {
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                for (NodeTuple nodeTuple : mappingNode.getValue()) {
                    Node keyNode = nodeTuple.getKeyNode();
                    if (!(keyNode instanceof ScalarNode)) continue;
                    ScalarNode scalarNode = (ScalarNode)keyNode;
                    requiredFields.remove(scalarNode.getValue());
                }
            }
            if (!requiredFields.isEmpty()) {
                throw new YAMLException(String.valueOf(aClass) + " is missing " + String.join((CharSequence)", ", requiredFields));
            }
        }
    }
}

