/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.MapModuleConfig;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.ModuleConfigRepository;
import com.powsybl.commons.xml.XmlUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesModuleConfigRepository
implements ModuleConfigRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesModuleConfigRepository.class);
    private final Path configDir;

    public PropertiesModuleConfigRepository(Path configDir) {
        this.configDir = Objects.requireNonNull(configDir);
    }

    private Path getModulePath(String name) {
        return this.configDir.resolve(name + ".properties");
    }

    @Override
    public Optional<ModuleConfig> getModuleConfig(String name) {
        Path path = this.getModulePath(name);
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        LOGGER.info("Reading property file {}", (Object)path);
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Optional.of(new MapModuleConfig(properties, this.configDir.getFileSystem()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXml(Path configDir, Path xmlFile) throws IOException, XMLStreamException {
        XMLOutputFactory output = XmlUtil.getXMLOutputFactory();
        try (BufferedWriter writer = Files.newBufferedWriter(xmlFile, StandardCharsets.UTF_8, new OpenOption[0]);
             XMLStreamWriter xmlWriter = output.createXMLStreamWriter(writer);){
            xmlWriter.writeStartDocument(StandardCharsets.UTF_8.toString(), "1.0");
            xmlWriter.writeStartElement("config");
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(configDir, entry -> Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().endsWith(".properties"));){
                for (Path file : ds) {
                    String fileName = file.getFileName().toString();
                    String fileNameWithoutExtension = fileName.substring(0, fileName.length() - 11);
                    xmlWriter.writeStartElement(fileNameWithoutExtension);
                    Properties properties = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        properties.load(reader);
                    }
                    for (String name : properties.stringPropertyNames()) {
                        String value = properties.getProperty(name);
                        xmlWriter.writeStartElement(name);
                        xmlWriter.writeCharacters(value);
                        xmlWriter.writeEndElement();
                    }
                    xmlWriter.writeEndElement();
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
        }
    }
}

