/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.google.re2j.Pattern;
import com.powsybl.commons.datasource.AbstractFileSystemDataSource;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileInformation;
import com.powsybl.commons.datasource.ObservableInputStream;
import com.powsybl.commons.datasource.ObservableOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DirectoryDataSource
extends AbstractFileSystemDataSource {
    private final boolean allFiles;

    public DirectoryDataSource(Path directory, String baseName) {
        this(directory, baseName, null, null, null);
    }

    public DirectoryDataSource(Path directory, String baseName, DataSourceObserver observer) {
        this(directory, baseName, null, null, observer);
    }

    public DirectoryDataSource(Path directory, String baseName, String dataExtension, DataSourceObserver observer) {
        this(directory, baseName, dataExtension, null, observer);
    }

    public DirectoryDataSource(Path directory, String baseName, String dataExtension, boolean allFiles, DataSourceObserver observer) {
        this(directory, baseName, dataExtension, null, allFiles, observer);
    }

    DirectoryDataSource(Path directory, String baseName, String dataExtension, CompressionFormat compressionFormat, DataSourceObserver observer) {
        this(directory, baseName, dataExtension, compressionFormat, false, observer);
    }

    DirectoryDataSource(Path directory, String baseName, String dataExtension, CompressionFormat compressionFormat, boolean allFiles, DataSourceObserver observer) {
        super(directory, baseName, dataExtension, compressionFormat, observer);
        this.allFiles = allFiles;
    }

    public boolean isAllFiles() {
        return this.allFiles;
    }

    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return is;
    }

    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return os;
    }

    private Path getPath(String fileName) {
        Objects.requireNonNull(fileName);
        FileInformation fileInformation = new FileInformation(fileName, false);
        return this.directory.resolve((String)(fileInformation.getCompressionFormat() == null ? fileName + this.getCompressionExtension() : fileName));
    }

    @Override
    public OutputStream newOutputStream(String suffix, String ext, boolean append) throws IOException {
        return this.newOutputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext), append);
    }

    @Override
    public OutputStream newOutputStream(String fileName, boolean append) throws IOException {
        Path path = this.getPath(fileName);
        OutputStream os = this.getCompressedOutputStream(Files.newOutputStream(path, DataSourceUtil.getOpenOptions(append)));
        return this.observer != null ? new ObservableOutputStream(os, path.toString(), this.observer) : os;
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        Path path = this.getPath(fileName);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        Path path = this.getPath(fileName);
        InputStream is = this.getCompressedInputStream(Files.newInputStream(path, new OpenOption[0]));
        return this.observer != null ? new ObservableInputStream(is, path.toString(), this.observer) : is;
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        Pattern p = Pattern.compile((String)regex);
        int maxDepth = 1;
        try (Stream<Path> paths = Files.walk(this.directory, maxDepth, new FileVisitOption[0]);){
            Stream<String> filenames = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString);
            if (!this.allFiles) {
                filenames = filenames.filter(name -> name.startsWith(this.baseName));
            }
            Set<String> set = filenames.map(name -> name.replace(this.getCompressionExtension(), "")).filter(s -> p.matcher((CharSequence)s).matches()).collect(Collectors.toSet());
            return set;
        }
    }
}

