/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.google.common.io.ByteStreams;
import com.google.re2j.Pattern;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ReadOnlyMemDataSource
implements ReadOnlyDataSource {
    private final Map<String, byte[]> data = new HashMap<String, byte[]>();
    private final String baseName;

    public ReadOnlyMemDataSource() {
        this("");
    }

    public ReadOnlyMemDataSource(String baseName) {
        this.baseName = Objects.requireNonNull(baseName);
    }

    public byte[] getData(String suffix, String ext) {
        return this.getData(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    public byte[] getData(String fileName) {
        return this.data.get(fileName);
    }

    public void putData(String fileName, InputStream data) {
        try {
            this.putData(fileName, ByteStreams.toByteArray((InputStream)data));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putData(String fileName, byte[] data) {
        this.data.put(fileName, data);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        return this.exists(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public boolean isDataExtension(String ext) {
        return true;
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        Objects.requireNonNull(fileName);
        return this.data.containsKey(fileName);
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        Objects.requireNonNull(fileName);
        byte[] ba = this.data.get(fileName);
        if (ba == null) {
            throw new IOException(fileName + " does not exist");
        }
        return new ByteArrayInputStream(ba);
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        Pattern p = Pattern.compile((String)regex);
        return this.data.keySet().stream().filter(name -> p.matcher((CharSequence)name).matches()).collect(Collectors.toSet());
    }
}

