/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.MessageTemplateProvider;
import com.powsybl.commons.report.ReportConstants;
import com.powsybl.commons.report.TreeContext;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeContextImpl
implements TreeContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeContextImpl.class);
    private final SortedMap<String, String> dictionary = new TreeMap<String, String>();
    private final Locale locale;
    private final DateTimeFormatter timestampFormatter;

    public TreeContextImpl() {
        this(Locale.getDefault(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public TreeContextImpl(Locale locale, String timestampPattern) {
        this.locale = Objects.requireNonNullElse(locale, Locale.getDefault());
        this.timestampFormatter = TreeContextImpl.createDateTimeFormatter(timestampPattern, locale);
    }

    private static DateTimeFormatter createDateTimeFormatter(String timestampPattern, Locale locale) {
        if (timestampPattern == null && locale == null) {
            return ReportConstants.DEFAULT_TIMESTAMP_FORMATTER;
        }
        if (timestampPattern == null) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", locale);
        }
        if (locale == null) {
            return DateTimeFormatter.ofPattern(timestampPattern);
        }
        return DateTimeFormatter.ofPattern(timestampPattern, locale);
    }

    @Override
    public Map<String, String> getDictionary() {
        return Collections.unmodifiableMap(this.dictionary);
    }

    @Override
    public DateTimeFormatter getDefaultTimestampFormatter() {
        return this.timestampFormatter;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public synchronized void merge(TreeContext otherContext) {
        otherContext.getDictionary().forEach(this::addDictionaryEntry);
    }

    @Override
    public void addDictionaryEntry(String key, MessageTemplateProvider messageTemplateProvider) {
        Objects.requireNonNull(messageTemplateProvider);
        this.addDictionaryEntry(key, messageTemplateProvider.getTemplate(key, this.locale));
    }

    public synchronized void addDictionaryEntry(String key, String messageTemplate) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(messageTemplate);
        this.dictionary.merge(key, messageTemplate, (prevMsg, newMsg) -> TreeContextImpl.mergeEntries(key, prevMsg, newMsg));
    }

    private static String mergeEntries(String key, String previousMessageTemplate, String newMessageTemplate) {
        if (!previousMessageTemplate.equals(newMessageTemplate)) {
            LOGGER.warn("Same key {} for two non-equal message templates: '{}' / '{}'. Keeping the first one.", new Object[]{key, previousMessageTemplate, newMessageTemplate});
        }
        return previousMessageTemplate;
    }
}

