/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.powsybl.computation.local.LocalCommandExecutor;
import com.powsybl.computation.local.ProcessHelper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractLocalCommandExecutor
implements LocalCommandExecutor {
    protected final Map<Path, Process> processMap = new HashMap<Path, Process>();
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected static final String NON_ZERO_LOG_PATTERN = "Command '{}' has failed (exitValue={})";

    @Override
    public void stop(Path workingDir) {
        Process process = this.getProcessByWorkingDir(workingDir);
        if (process != null) {
            process.destroy();
        }
    }

    @Override
    public void stopForcibly(Path workingDir) throws InterruptedException {
        Process process = this.getProcessByWorkingDir(workingDir);
        if (process != null) {
            Process killProcess = process.destroyForcibly();
            killProcess.waitFor();
        }
    }

    private Process getProcessByWorkingDir(Path workingDir) {
        try {
            this.lock.readLock().lock();
            Process process = this.processMap.get(workingDir);
            return process;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(List<String> cmdLs, Path workingDir, Path outFile, Path errFile, long timeout) throws IOException, InterruptedException {
        ProcessBuilder.Redirect outRedirect = ProcessBuilder.Redirect.appendTo(outFile.toFile());
        ProcessBuilder.Redirect errRedirect = ProcessBuilder.Redirect.appendTo(errFile.toFile());
        Process process = new ProcessBuilder(cmdLs).directory(workingDir.toFile()).redirectOutput(outRedirect).redirectError(errRedirect).start();
        try {
            this.lock.writeLock().lock();
            this.processMap.put(workingDir, process);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        int exitCode = timeout <= 0L ? process.waitFor() : ProcessHelper.runWithTimeout(timeout, process);
        if (exitCode != 0) {
            this.nonZeroLog(cmdLs, exitCode);
        }
        return exitCode;
    }

    abstract void nonZeroLog(List<String> var1, int var2);
}

