/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.powsybl.computation.ComputationResourcesStatus;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;

class LocalComputationResourcesStatus
implements ComputationResourcesStatus {
    private final int availableCores;
    private ZonedDateTime date;
    private int busyCores = 0;

    LocalComputationResourcesStatus(int availableCores) {
        this.availableCores = availableCores;
    }

    public synchronized ZonedDateTime getDate() {
        return this.date;
    }

    public int getAvailableCores() {
        return this.availableCores;
    }

    public synchronized int getBusyCores() {
        return this.busyCores;
    }

    public synchronized Map<String, Integer> getBusyCoresPerApp() {
        return Collections.singletonMap("all", this.busyCores);
    }

    synchronized void incrementNumberOfBusyCores() {
        this.date = ZonedDateTime.now(ZoneOffset.UTC);
        ++this.busyCores;
    }

    synchronized void decrementNumberOfBusyCores() {
        this.date = ZonedDateTime.now(ZoneOffset.UTC);
        --this.busyCores;
    }
}

