/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.powsybl.computation.local.AbstractLocalCommandExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixLocalCommandExecutor
extends AbstractLocalCommandExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnixLocalCommandExecutor.class);

    @Override
    public int execute(String program, List<String> args, Path outFile, Path errFile, Path workingDir, Map<String, String> env) throws IOException, InterruptedException {
        return this.execute(program, -1L, args, outFile, errFile, workingDir, env);
    }

    @Override
    public int execute(String program, long timeoutSecondes, List<String> args, Path outFile, Path errFile, Path workingDir, Map<String, String> env) throws IOException, InterruptedException {
        ImmutableMap env2 = ImmutableMap.builder().putAll(env).put((Object)"TMPDIR", (Object)workingDir.toAbsolutePath().toString()).build();
        StringBuilder internalCmd = new StringBuilder();
        for (Map.Entry entry : env2.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            internalCmd.append(name).append("=").append(value);
            if (name.endsWith("PATH")) {
                internalCmd.append(File.pathSeparator).append("$").append(name);
            }
            internalCmd.append(" ");
        }
        internalCmd.append(program);
        for (String arg : args) {
            internalCmd.append(" \"").append(arg).append("\"");
        }
        ImmutableList cmdLs = ImmutableList.builder().add((Object)"bash").add((Object)"-c").add((Object)internalCmd.toString()).build();
        return this.execute((List<String>)cmdLs, workingDir, outFile, errFile, timeoutSecondes);
    }

    @Override
    void nonZeroLog(List<String> cmdLs, int exitCode) {
        LOGGER.debug("Command '{}' has failed (exitValue={})", cmdLs, (Object)exitCode);
    }
}

