/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class ProcessHelper {
    private static final long DEFAULT_FAST_POLLING = 500000000L;
    private static final long BEGINING_NANO = 3000000000L;

    static int runWithTimeout(long timeoutInSeconds, Process process) throws InterruptedException, IOException {
        Preconditions.checkArgument((timeoutInSeconds > 0L ? 1 : 0) != 0, (String)"negative timeout: %s", (long)timeoutInSeconds);
        long startTimeNano = System.nanoTime();
        while (true) {
            try {
                int exitCode = process.exitValue();
                ProcessHelper.closeStream(process);
                return exitCode;
            }
            catch (IllegalThreadStateException ex) {
                long running = System.nanoTime() - startTimeNano;
                if (running <= TimeUnit.SECONDS.toNanos(timeoutInSeconds)) {
                    TimeUnit.NANOSECONDS.sleep(ProcessHelper.smartWait(running, startTimeNano, timeoutInSeconds));
                    continue;
                }
                process.destroy();
                int exitCode = 124;
                ProcessHelper.closeStream(process);
                return exitCode;
            }
            break;
        }
    }

    private static long smartWait(long running, long startTime, long timeout) {
        if (running < 3000000000L || (double)running > 0.8 * (double)TimeUnit.SECONDS.toNanos(timeout)) {
            return 500000000L;
        }
        return (long)((double)TimeUnit.SECONDS.toNanos(timeout) * 0.8) - running;
    }

    private static void closeStream(Process process) throws IOException {
        process.getInputStream().close();
        process.getOutputStream().close();
        process.getErrorStream().close();
    }

    private ProcessHelper() {
    }
}

