/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.google.common.base.Stopwatch;
import com.google.common.io.ByteStreams;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.io.WorkingDirectory;
import com.powsybl.computation.Command;
import com.powsybl.computation.CommandExecution;
import com.powsybl.computation.CompletableFutureTask;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ComputationParameters;
import com.powsybl.computation.ComputationResourcesStatus;
import com.powsybl.computation.DefaultExecutionReport;
import com.powsybl.computation.ExecutionEnvironment;
import com.powsybl.computation.ExecutionError;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.computation.ExecutionReport;
import com.powsybl.computation.FilePostProcessor;
import com.powsybl.computation.GroupCommand;
import com.powsybl.computation.InputFile;
import com.powsybl.computation.OutputFile;
import com.powsybl.computation.SimpleCommand;
import com.powsybl.computation.local.LocalCommandExecutor;
import com.powsybl.computation.local.LocalComputationConfig;
import com.powsybl.computation.local.LocalComputationResourcesStatus;
import com.powsybl.computation.local.UnixLocalCommandExecutor;
import com.powsybl.computation.local.WindowsLocalCommandExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalComputationManager
implements ComputationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalComputationManager.class);
    private final LocalComputationConfig config;
    private final WorkingDirectory commonDir;
    private final LocalComputationResourcesStatus status;
    private final Semaphore permits;
    private final Executor threadPool;
    private final LocalCommandExecutor localCommandExecutor;
    private static final Lock LOCK = new ReentrantLock();
    private static LocalComputationManager defaultInstance;

    public static ComputationManager getDefault() {
        LOCK.lock();
        try {
            if (defaultInstance == null) {
                try {
                    defaultInstance = new LocalComputationManager();
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> defaultInstance.close()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            LocalComputationManager localComputationManager = defaultInstance;
            return localComputationManager;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static LocalCommandExecutor getLocalCommandExecutor() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new WindowsLocalCommandExecutor();
        }
        if (SystemUtils.IS_OS_UNIX) {
            return new UnixLocalCommandExecutor();
        }
        throw new UnsupportedOperationException("OS not supported for local execution");
    }

    public LocalComputationManager() throws IOException {
        this(LocalComputationConfig.load());
    }

    public LocalComputationManager(Executor executor) throws IOException {
        this(LocalComputationConfig.load(), executor);
    }

    public LocalComputationManager(PlatformConfig platformConfig) throws IOException {
        this(LocalComputationConfig.load(platformConfig));
    }

    public LocalComputationManager(Path localDir) throws IOException {
        this(new LocalComputationConfig(localDir));
    }

    public LocalComputationManager(LocalComputationConfig config) throws IOException {
        this(config, ForkJoinPool.commonPool());
    }

    public LocalComputationManager(LocalComputationConfig config, Executor executor) throws IOException {
        this(config, LocalComputationManager.getLocalCommandExecutor(), executor);
    }

    public LocalComputationManager(LocalComputationConfig config, LocalCommandExecutor localCommandExecutor, Executor executor) throws IOException {
        this.config = Objects.requireNonNull(config);
        this.localCommandExecutor = Objects.requireNonNull(localCommandExecutor);
        this.threadPool = Objects.requireNonNull(executor);
        this.status = new LocalComputationResourcesStatus(config.getAvailableCore());
        this.permits = new Semaphore(config.getAvailableCore());
        Files.createDirectories(config.getLocalDir(), new FileAttribute[0]);
        this.commonDir = new WorkingDirectory(config.getLocalDir(), "itools_common_", false);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(config.toString());
        }
    }

    public String getVersion() {
        return "none (local mode)";
    }

    public Path getLocalDir() {
        return this.config.getLocalDir();
    }

    public OutputStream newCommonFile(String fileName) throws IOException {
        return Files.newOutputStream(this.commonDir.toPath().resolve(fileName), new OpenOption[0]);
    }

    private ExecutionReport execute(Path workingDir, List<CommandExecution> commandExecutionList, Map<String, String> variables, ComputationParameters computationParameters, ExecutionMonitor monitor) throws InterruptedException {
        ArrayList<ExecutionError> errors = new ArrayList<ExecutionError>();
        ExecutorService executionSubmitter = Executors.newCachedThreadPool();
        for (CommandExecution commandExecution : commandExecutionList) {
            Command command = commandExecution.getCommand();
            CountDownLatch latch = new CountDownLatch(commandExecution.getExecutionCount());
            ExecutionParameters executionParameters = new ExecutionParameters(workingDir, commandExecution, variables, computationParameters, executionSubmitter, command, latch, errors, monitor);
            IntStream.range(0, commandExecution.getExecutionCount()).forEach(idx -> this.performSingleExecution(executionParameters, idx));
            latch.await();
        }
        executionSubmitter.shutdown();
        if (!executionSubmitter.awaitTermination(20L, TimeUnit.SECONDS)) {
            executionSubmitter.shutdownNow();
            if (!executionSubmitter.awaitTermination(20L, TimeUnit.SECONDS)) {
                LOGGER.error("Thread pool did not terminate");
            }
        }
        return new DefaultExecutionReport(workingDir, errors);
    }

    private void performSingleExecution(ExecutionParameters executionParameters, int idx) {
        executionParameters.executionSubmitter.execute(() -> {
            try {
                this.enter();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing command {} in working directory {}", (Object)executionParameters.command.toString(idx), (Object)executionParameters.workingDir);
                }
                this.preProcess(executionParameters.workingDir, executionParameters.command, idx);
                Stopwatch stopwatch = null;
                if (LOGGER.isDebugEnabled()) {
                    stopwatch = Stopwatch.createStarted();
                }
                int exitValue = this.process(executionParameters.workingDir, executionParameters.commandExecution, idx, executionParameters.variables, executionParameters.computationParameters);
                if (stopwatch != null) {
                    stopwatch.stop();
                    LOGGER.debug("Command {} executed in {} ms", (Object)executionParameters.command.toString(idx), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                }
                this.postProcess(executionParameters.workingDir, executionParameters.commandExecution, idx, exitValue, executionParameters.errors, executionParameters.monitor);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                executionParameters.latch.countDown();
                this.exit();
            }
        });
    }

    private void preProcess(Path workingDir, Command command, int executionIndex) throws IOException {
        block19: for (InputFile file : command.getInputFiles()) {
            String fileName = file.getName(executionIndex);
            Path path = this.checkInputFileExistsInWorkingAndCommons(workingDir, fileName, file);
            if (file.getPreProcessor() == null) continue;
            switch (file.getPreProcessor()) {
                case FILE_GUNZIP: {
                    GZIPInputStream is = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
                    try {
                        OutputStream os = Files.newOutputStream(workingDir.resolve(fileName.substring(0, fileName.length() - 3)), new OpenOption[0]);
                        try {
                            ByteStreams.copy((InputStream)is, (OutputStream)os);
                            continue block19;
                        }
                        finally {
                            if (os == null) continue block19;
                            os.close();
                            continue block19;
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                        continue block19;
                    }
                }
                case ARCHIVE_UNZIP: {
                    ZipFile zipFile = ZipFile.builder().setSeekableByteChannel(Files.newByteChannel(path, new OpenOption[0])).get();
                    try {
                        for (ZipArchiveEntry ze : Collections.list(zipFile.getEntries())) {
                            Files.copy(zipFile.getInputStream(zipFile.getEntry(ze.getName())), workingDir.resolve(ze.getName()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        continue block19;
                    }
                    finally {
                        if (zipFile == null) continue block19;
                        zipFile.close();
                        continue block19;
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected FilePreProcessor value: " + file.getPreProcessor());
                }
            }
        }
    }

    private int process(Path workingDir, CommandExecution commandExecution, int executionIndex, Map<String, String> variables, ComputationParameters computationParameters) throws IOException, InterruptedException {
        Command command = commandExecution.getCommand();
        int exitValue = 0;
        long timeout = -1L;
        Path outFile = workingDir.resolve(command.getId() + "_" + executionIndex + ".out");
        Path errFile = workingDir.resolve(command.getId() + "_" + executionIndex + ".err");
        Map executionVariables = CommandExecution.getExecutionVariables(variables, (CommandExecution)commandExecution);
        switch (command.getType()) {
            case SIMPLE: {
                SimpleCommand simpleCmd = (SimpleCommand)command;
                timeout = computationParameters.getTimeout(simpleCmd.getId()).orElse(-1L);
                exitValue = this.localCommandExecutor.execute(simpleCmd.getProgram(), timeout, simpleCmd.getArgs(executionIndex), outFile, errFile, workingDir, executionVariables);
                break;
            }
            case GROUP: {
                GroupCommand.SubCommand subCmd;
                Iterator iterator = ((GroupCommand)command).getSubCommands().iterator();
                while (iterator.hasNext() && (exitValue = this.localCommandExecutor.execute((subCmd = (GroupCommand.SubCommand)iterator.next()).getProgram(), subCmd.getArgs(executionIndex), outFile, errFile, workingDir, executionVariables)) == 0) {
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected CommandType value: " + command.getType());
            }
        }
        return exitValue;
    }

    private void postProcess(Path workingDir, CommandExecution commandExecution, int executionIndex, int exitValue, List<ExecutionError> errors, ExecutionMonitor monitor) throws IOException {
        Command command = commandExecution.getCommand();
        if (exitValue != 0) {
            errors.add(new ExecutionError(command, executionIndex, exitValue));
        } else {
            for (OutputFile file : command.getOutputFiles()) {
                String fileName = file.getName(executionIndex);
                Path path = workingDir.resolve(fileName);
                if (file.getPostProcessor() == null || !Files.isRegularFile(path, new LinkOption[0])) continue;
                if (file.getPostProcessor() == FilePostProcessor.FILE_GZIP) {
                    InputStream is = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        GZIPOutputStream os = new GZIPOutputStream(Files.newOutputStream(workingDir.resolve(fileName + ".gz"), new OpenOption[0]));
                        try {
                            ByteStreams.copy((InputStream)is, (OutputStream)os);
                            continue;
                        }
                        finally {
                            ((OutputStream)os).close();
                            continue;
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        continue;
                    }
                }
                throw new IllegalStateException("Unexpected FilePostProcessor value: " + file.getPostProcessor());
            }
        }
        if (monitor != null) {
            monitor.onProgress(commandExecution, executionIndex);
        }
    }

    private Path checkInputFileExistsInWorkingAndCommons(Path workingDir, String fileName, InputFile file) throws IOException {
        Path path = workingDir.resolve(fileName);
        if (!Files.exists(path, new LinkOption[0])) {
            path = this.commonDir.toPath().resolve(fileName);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new PowsyblException("Input file '" + fileName + "' not found in the working and common directory");
            }
            if (file.getPreProcessor() == null) {
                Files.copy(path, workingDir.resolve(path.getFileName()), new CopyOption[0]);
            }
        }
        return path;
    }

    private void enter() throws InterruptedException {
        this.permits.acquire();
        this.status.incrementNumberOfBusyCores();
    }

    private void exit() {
        this.status.decrementNumberOfBusyCores();
        this.permits.release();
    }

    public <R> CompletableFuture<R> execute(ExecutionEnvironment environment, ExecutionHandler<R> handler) {
        return this.execute(environment, handler, ComputationParameters.empty());
    }

    public <R> CompletableFuture<R> execute(ExecutionEnvironment environment, ExecutionHandler<R> handler, ComputationParameters parameters) {
        Objects.requireNonNull(environment);
        Objects.requireNonNull(handler);
        return CompletableFutureTask.runAsync(() -> this.doExecute(environment, handler, parameters), (Executor)this.threadPool);
    }

    private <R> R doExecute(ExecutionEnvironment environment, ExecutionHandler<R> handler, ComputationParameters parameters) throws IOException, InterruptedException {
        try (WorkingDirectory workingDir = new WorkingDirectory(this.config.getLocalDir(), environment.getWorkingDirPrefix(), environment.isDebug());){
            ExecutionReport report;
            List commandExecutionList = handler.before(workingDir.toPath());
            try {
                report = this.execute(workingDir.toPath(), commandExecutionList, environment.getVariables(), parameters, (arg_0, arg_1) -> handler.onExecutionCompletion(arg_0, arg_1));
            }
            catch (InterruptedException exc) {
                this.localCommandExecutor.stop(workingDir.toPath());
                throw exc;
            }
            Object object = handler.after(workingDir.toPath(), report);
            return (R)object;
        }
    }

    public ComputationResourcesStatus getResourcesStatus() {
        return this.status;
    }

    public Executor getExecutor() {
        return this.threadPool;
    }

    public void close() {
        try {
            this.commonDir.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record ExecutionParameters(Path workingDir, CommandExecution commandExecution, Map<String, String> variables, ComputationParameters computationParameters, ExecutorService executionSubmitter, Command command, CountDownLatch latch, List<ExecutionError> errors, ExecutionMonitor monitor) {
    }

    private static interface ExecutionMonitor {
        public void onProgress(CommandExecution var1, int var2);
    }
}

