/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.local;

import com.powsybl.commons.config.ConfigurationException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LocalComputationConfig {
    private static final String CONFIG_MODULE_NAME = "computation-local";
    static final String DEFAULT_LOCAL_DIR = System.getProperty("java.io.tmpdir");
    private static final int DEFAULT_AVAILABLE_CORE = 1;
    private final Path localDir;
    private final int availableCore;

    public static LocalComputationConfig load() {
        return LocalComputationConfig.load(PlatformConfig.defaultConfig());
    }

    public static LocalComputationConfig load(PlatformConfig platformConfig) {
        return LocalComputationConfig.load(platformConfig, FileSystems.getDefault());
    }

    private static Path getDefaultLocalDir(FileSystem fileSystem) {
        return fileSystem.getPath(DEFAULT_LOCAL_DIR, new String[0]);
    }

    private static Optional<Path> getTmpDir(ModuleConfig config, String name) {
        return config.getOptionalPathListProperty(name).map(paths -> {
            if (paths.isEmpty()) {
                throw new ConfigurationException("Empty tmp dir list");
            }
            List<Path> checkedPaths = paths.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
            if (checkedPaths.isEmpty()) {
                throw new ConfigurationException("None of the tmp dir path of the list exist");
            }
            return checkedPaths.get(0);
        });
    }

    public static LocalComputationConfig load(PlatformConfig platformConfig, FileSystem fileSystem) {
        Objects.requireNonNull(platformConfig);
        Optional config = platformConfig.getOptionalModuleConfig(CONFIG_MODULE_NAME);
        Path localDir = config.flatMap(c -> LocalComputationConfig.getTmpDir(c, "tmp-dir").or(() -> LocalComputationConfig.getTmpDir(c, "tmpDir"))).orElse(LocalComputationConfig.getDefaultLocalDir(fileSystem));
        int availableCore = config.map(c -> c.getOptionalIntProperty("available-core").orElse(c.getOptionalIntProperty("availableCore").orElse(1))).orElse(1);
        if (availableCore <= 0) {
            availableCore = Runtime.getRuntime().availableProcessors();
        }
        return new LocalComputationConfig(localDir, availableCore);
    }

    public LocalComputationConfig(Path localDir) {
        this(localDir, 1);
    }

    public LocalComputationConfig(Path localDir, int availableCore) {
        this.localDir = localDir;
        this.availableCore = availableCore;
    }

    public Path getLocalDir() {
        return this.localDir;
    }

    public int getAvailableCore() {
        return this.availableCore;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [localDir=" + this.localDir + ", availableCore=" + this.availableCore + "]";
    }
}

