/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.exceptions.UncheckedClassNotFoundException;
import com.powsybl.commons.exceptions.UncheckedIllegalAccessException;
import com.powsybl.commons.exceptions.UncheckedInstantiationException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ComputationManagerFactory;
import com.powsybl.computation.LazyCreatedComputationManager;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComputationManagerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultComputationManagerConfig.class);
    private static final String DEFAULT_SHORT_TIME_EXECUTION_COMPUTATION_MANAGER_FACTORY_CLASS = "com.powsybl.computation.local.LocalComputationManagerFactory";
    private final Class<? extends ComputationManagerFactory> shortTimeExecutionComputationManagerFactoryClass;
    private final Class<? extends ComputationManagerFactory> longTimeExecutionComputationManagerFactoryClass;

    public DefaultComputationManagerConfig(Class<? extends ComputationManagerFactory> shortTimeExecutionComputationManagerFactoryClass, Class<? extends ComputationManagerFactory> longTimeExecutionComputationManagerFactoryClass) {
        this.shortTimeExecutionComputationManagerFactoryClass = Objects.requireNonNull(shortTimeExecutionComputationManagerFactoryClass);
        this.longTimeExecutionComputationManagerFactoryClass = longTimeExecutionComputationManagerFactoryClass;
    }

    public static DefaultComputationManagerConfig load() {
        return DefaultComputationManagerConfig.load(PlatformConfig.defaultConfig());
    }

    public static DefaultComputationManagerConfig load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        DefaultComputationManagerConfig config = platformConfig.getOptionalModuleConfig("default-computation-manager").map(moduleConfig -> {
            Class shortTimeExecutionComputationManagerFactoryClass = moduleConfig.getClassProperty("short-time-execution-computation-manager-factory", ComputationManagerFactory.class);
            Class longTimeExecutionComputationManagerFactoryClass = moduleConfig.getClassProperty("long-time-execution-computation-manager-factory", ComputationManagerFactory.class, null);
            return new DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass, longTimeExecutionComputationManagerFactoryClass);
        }).orElseGet(() -> {
            Class<?> shortTimeExecutionComputationManagerFactoryClass;
            try {
                shortTimeExecutionComputationManagerFactoryClass = Class.forName(DEFAULT_SHORT_TIME_EXECUTION_COMPUTATION_MANAGER_FACTORY_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedClassNotFoundException(e);
            }
            return new DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass, null);
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(config.toString());
        }
        return config;
    }

    public ComputationManager createShortTimeExecutionComputationManager() {
        try {
            return new LazyCreatedComputationManager(this.shortTimeExecutionComputationManagerFactoryClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new UncheckedInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedIllegalAccessException(e);
        }
    }

    public ComputationManager createLongTimeExecutionComputationManager() {
        if (this.longTimeExecutionComputationManagerFactoryClass != null) {
            try {
                return new LazyCreatedComputationManager(this.longTimeExecutionComputationManagerFactoryClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new UncheckedInstantiationException(e);
            }
            catch (IllegalAccessException e) {
                throw new UncheckedIllegalAccessException(e);
            }
        }
        return this.createShortTimeExecutionComputationManager();
    }

    public String toString() {
        String str = "DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass=" + this.shortTimeExecutionComputationManagerFactoryClass.getName() + ", longTimeExecutionComputationManagerFactoryClass=";
        str = this.longTimeExecutionComputationManagerFactoryClass != null ? str + this.longTimeExecutionComputationManagerFactoryClass.getName() : str + this.shortTimeExecutionComputationManagerFactoryClass.getName();
        str = str + ")";
        return str;
    }
}

