/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.collect.ImmutableList;
import com.powsybl.computation.Command;
import com.powsybl.computation.ExecutionError;
import com.powsybl.computation.ExecutionReport;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionReport
implements ExecutionReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionReport.class);
    private final Path workingDirectory;
    private final List<ExecutionError> errors;

    public DefaultExecutionReport(Path workingDirectory) {
        this(workingDirectory, Collections.emptyList());
    }

    public DefaultExecutionReport(Path workingDirectory, List<ExecutionError> errors) {
        this.workingDirectory = Objects.requireNonNull(workingDirectory);
        this.errors = ImmutableList.copyOf((Collection)Objects.requireNonNull(errors));
    }

    @Override
    public List<ExecutionError> getErrors() {
        return this.errors;
    }

    @Override
    public void log() {
        if (!this.errors.isEmpty()) {
            LOGGER.error("{} commands have failed: {}", (Object)this.errors.size(), this.errors);
            if (LOGGER.isTraceEnabled()) {
                for (ExecutionError error : this.errors) {
                    LOGGER.trace("Command {} exits with code {}", (Object)error.getCommand().toString(error.getIndex()), (Object)error.getExitCode());
                }
            }
        }
    }

    @Override
    public Optional<InputStream> getStdOut(Command command, int index) {
        return this.getOutputFile(command, index, ".out");
    }

    @Override
    public Optional<InputStream> getStdErr(Command command, int index) {
        return this.getOutputFile(command, index, ".err");
    }

    private Optional<InputStream> getOutputFile(Command command, int index, String extension) {
        Objects.requireNonNull(command);
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        Path path = this.workingDirectory.resolve(command.getId() + "_" + index + extension);
        try {
            return Optional.of(Files.newInputStream(path, StandardOpenOption.READ));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read {}: {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }
}

