/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ComputationManagerFactory;
import com.powsybl.computation.ComputationParameters;
import com.powsybl.computation.ComputationResourcesStatus;
import com.powsybl.computation.ExecutionEnvironment;
import com.powsybl.computation.ExecutionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class LazyCreatedComputationManager
implements ComputationManager {
    private final ComputationManagerFactory factory;
    private ComputationManager delegate;

    public LazyCreatedComputationManager(ComputationManagerFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    private synchronized ComputationManager getComputationManager() {
        if (this.delegate == null) {
            this.delegate = this.factory.create();
            Objects.requireNonNull(this.delegate, "Computation manager factory returned null");
        }
        return this.delegate;
    }

    @Override
    public String getVersion() {
        return this.getComputationManager().getVersion();
    }

    @Override
    public OutputStream newCommonFile(String fileName) throws IOException {
        return this.getComputationManager().newCommonFile(fileName);
    }

    @Override
    public <R> CompletableFuture<R> execute(ExecutionEnvironment environment, ExecutionHandler<R> handler) {
        return this.getComputationManager().execute(environment, handler);
    }

    @Override
    public <R> CompletableFuture<R> execute(ExecutionEnvironment environment, ExecutionHandler<R> handler, ComputationParameters parameters) {
        return this.getComputationManager().execute(environment, handler, parameters);
    }

    @Override
    public ComputationResourcesStatus getResourcesStatus() {
        return this.getComputationManager().getResourcesStatus();
    }

    @Override
    public Executor getExecutor() {
        return this.getComputationManager().getExecutor();
    }

    @Override
    public Path getLocalDir() {
        return this.getComputationManager().getLocalDir();
    }

    @Override
    public synchronized void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

