/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.collect.ImmutableMap;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.compress.ZipPackager;
import java.util.Map;
import java.util.Objects;

public final class ComputationException
extends PowsyblException {
    private final Map<String, String> outLogs;
    private final Map<String, String> errLogs;
    private final Map<String, byte[]> fileBytes;

    ComputationException(Map<String, String> outMap, Map<String, String> errMap, Map<String, byte[]> fileBytesMap) {
        this.outLogs = ImmutableMap.copyOf(Objects.requireNonNull(outMap));
        this.errLogs = ImmutableMap.copyOf(Objects.requireNonNull(errMap));
        this.fileBytes = ImmutableMap.copyOf(Objects.requireNonNull(fileBytesMap));
    }

    ComputationException(String message, Map<String, String> outMap, Map<String, String> errMap, Map<String, byte[]> fileBytesMap) {
        super(message);
        this.outLogs = ImmutableMap.copyOf(Objects.requireNonNull(outMap));
        this.errLogs = ImmutableMap.copyOf(Objects.requireNonNull(errMap));
        this.fileBytes = ImmutableMap.copyOf(Objects.requireNonNull(fileBytesMap));
    }

    ComputationException(Throwable cause, Map<String, String> outMap, Map<String, String> errMap, Map<String, byte[]> fileBytesMap) {
        super(cause);
        this.outLogs = ImmutableMap.copyOf(Objects.requireNonNull(outMap));
        this.errLogs = ImmutableMap.copyOf(Objects.requireNonNull(errMap));
        this.fileBytes = ImmutableMap.copyOf(Objects.requireNonNull(fileBytesMap));
    }

    ComputationException(String message, Throwable cause, Map<String, String> outMap, Map<String, String> errMap, Map<String, byte[]> fileBytesMap) {
        super(message, cause);
        this.outLogs = ImmutableMap.copyOf(Objects.requireNonNull(outMap));
        this.errLogs = ImmutableMap.copyOf(Objects.requireNonNull(errMap));
        this.fileBytes = ImmutableMap.copyOf(Objects.requireNonNull(fileBytesMap));
    }

    public Map<String, String> getOutLogs() {
        return this.outLogs;
    }

    public Map<String, String> getErrLogs() {
        return this.errLogs;
    }

    public Map<String, byte[]> getFileBytes() {
        return this.fileBytes;
    }

    public byte[] toZipBytes() {
        ZipPackager zipPackager = new ZipPackager();
        this.outLogs.forEach((k, v) -> zipPackager.addString(k, v == null ? "" : v));
        this.errLogs.forEach((k, v) -> zipPackager.addString(k, v == null ? "" : v));
        this.fileBytes.forEach((arg_0, arg_1) -> ((ZipPackager)zipPackager).addBytes(arg_0, arg_1));
        return zipPackager.toZipBytes();
    }
}

