/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation.util;

import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractExecutor {
    private final ReentrantLock runLock = new ReentrantLock();
    private boolean initialized = false;
    private boolean shutdownRequested = false;
    private int runCounter = 0;

    protected void startInit() throws Exception {
        this.runLock.lock();
        try {
            if (this.initialized) {
                throw new IllegalStateException("Module is already initialized");
            }
        }
        finally {
            this.runLock.unlock();
        }
    }

    protected void endInit() throws Exception {
        this.runLock.lock();
        try {
            this.initialized = true;
        }
        finally {
            this.runLock.unlock();
        }
    }

    protected abstract void clean() throws Exception;

    protected void startRun() throws Exception {
        this.runLock.lock();
        try {
            if (!this.initialized) {
                throw new IllegalStateException("Module is not initialized");
            }
            if (this.shutdownRequested) {
                throw new IllegalStateException("Module has been shutdown");
            }
            ++this.runCounter;
        }
        finally {
            this.runLock.unlock();
        }
    }

    protected void endRun() throws Exception {
        this.runLock.lock();
        try {
            --this.runCounter;
            if (this.shutdownRequested && this.runCounter == 0) {
                this.clean();
            }
        }
        finally {
            this.runLock.unlock();
        }
    }

    public void close() throws Exception {
        this.runLock.lock();
        try {
            this.shutdownRequested = true;
            if (this.runCounter == 0) {
                this.clean();
            }
        }
        finally {
            this.runLock.unlock();
        }
    }
}

