/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.AbstractCommandBuilder;
import com.powsybl.computation.GroupCommand;
import com.powsybl.computation.GroupCommandImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GroupCommandBuilder
extends AbstractCommandBuilder<GroupCommandBuilder> {
    private final List<GroupCommand.SubCommand> subCommands = new ArrayList<GroupCommand.SubCommand>();

    public SubCommandBuilder subCommand() {
        return new SubCommandBuilder();
    }

    public GroupCommand build() {
        if (this.id == null) {
            throw new PowsyblException("id is not set");
        }
        return new GroupCommandImpl(this.id, this.subCommands, this.inputFiles, this.outputFiles);
    }

    public class SubCommandBuilder {
        private String program;
        private Function<Integer, List<String>> args = executionNumber -> Collections.emptyList();
        private int timeout = -1;

        public SubCommandBuilder program(String program) {
            this.program = program;
            return this;
        }

        public SubCommandBuilder args(Function<Integer, List<String>> args) {
            this.args = Objects.requireNonNull(args);
            return this;
        }

        public SubCommandBuilder args(List<String> args) {
            Objects.requireNonNull(args);
            this.args = executionNumber -> args.stream().map(arg -> arg.replace("${EXEC_NUM}", executionNumber.toString())).collect(Collectors.toList());
            return this;
        }

        public SubCommandBuilder args(String ... args) {
            Objects.requireNonNull(args);
            this.args(Arrays.asList(args));
            return this;
        }

        public SubCommandBuilder timeout(int timeout) {
            if (timeout < -1 || timeout == 0) {
                throw new PowsyblException("invalid timeout");
            }
            this.timeout = timeout;
            return this;
        }

        public GroupCommandBuilder add() {
            if (this.program == null) {
                throw new PowsyblException("program is not set");
            }
            GroupCommandBuilder.this.subCommands.add(new GroupCommandImpl.SubCommandImpl(this.program, this.args, this.timeout));
            return GroupCommandBuilder.this;
        }
    }
}

