/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.FileName;
import com.powsybl.computation.FilePostProcessor;
import com.powsybl.computation.FunctionFileName;
import com.powsybl.computation.StringFileName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class OutputFile {
    private final FileName name;
    private final FilePostProcessor postProcessor;

    public static List<OutputFile> of(String ... fileNames) {
        ArrayList<OutputFile> outputFiles = new ArrayList<OutputFile>(fileNames.length);
        for (String fileName : fileNames) {
            outputFiles.add(new OutputFile(fileName));
        }
        return outputFiles;
    }

    public OutputFile(String name) {
        this(name, null);
    }

    public OutputFile(String name, FilePostProcessor postProcessor) {
        this.name = new StringFileName(name);
        this.postProcessor = postProcessor;
    }

    public OutputFile(Function<Integer, String> nameFunc, FilePostProcessor postProcessor) {
        this.name = new FunctionFileName(nameFunc, null);
        this.postProcessor = postProcessor;
    }

    public String getName(int executionNumber) {
        return this.name.getName(executionNumber);
    }

    public FilePostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public boolean dependsOnExecutionNumber() {
        return this.name.dependsOnExecutionNumber();
    }
}

