/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.CommandExecution;
import com.powsybl.computation.ExecutionHandler;
import com.powsybl.computation.ExecutionReport;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Collectors;

public abstract class AbstractExecutionHandler<R>
implements ExecutionHandler<R> {
    @Override
    public void onExecutionStart(CommandExecution execution, int executionIndex) {
    }

    @Override
    public void onExecutionCompletion(CommandExecution execution, int executionIndex) {
    }

    @Override
    public R after(Path workingDir, ExecutionReport report) throws IOException {
        if (!report.getErrors().isEmpty()) {
            report.log();
            String exitCodes = report.getErrors().stream().map(err -> String.format("Task %d : %d", err.getIndex(), err.getExitCode())).collect(Collectors.joining(", "));
            throw new PowsyblException(String.format("Error during the execution in directory  %s exit codes: %s", workingDir.toAbsolutePath(), exitCodes));
        }
        return null;
    }
}

