/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.collect.ImmutableMap;
import com.powsybl.computation.Command;
import java.util.Map;
import java.util.Objects;

public class CommandExecution {
    private final Command command;
    private final int executionCount;
    private final int priority;
    private final Map<String, String> tags;
    private final Map<String, String> overloadedVariables;

    public static Map<String, String> getExecutionVariables(Map<String, String> variables, CommandExecution commandExecution) {
        Objects.requireNonNull(variables);
        Objects.requireNonNull(commandExecution);
        if (commandExecution.getOverloadedVariables() != null) {
            return ImmutableMap.builder().putAll(variables).putAll(commandExecution.getOverloadedVariables()).build();
        }
        return variables;
    }

    public CommandExecution(Command command, int executionCount) {
        this(command, executionCount, Integer.MAX_VALUE);
    }

    public CommandExecution(Command command, int executionCount, int priority) {
        this(command, executionCount, priority, null);
    }

    public CommandExecution(Command command, int executionCount, int priority, Map<String, String> tags) {
        this(command, executionCount, priority, tags, null);
    }

    public CommandExecution(Command command, int executionCount, int priority, Map<String, String> tags, Map<String, String> overloadedVariables) {
        this.command = Objects.requireNonNull(command, "command is null");
        if (executionCount < 1) {
            throw new IllegalArgumentException("execution count must be > 0");
        }
        this.executionCount = executionCount;
        this.priority = priority;
        this.tags = tags;
        this.overloadedVariables = overloadedVariables;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public int getPriority() {
        return this.priority;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getOverloadedVariables() {
        return this.overloadedVariables;
    }
}

