/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.extensions.AbstractExtendable;
import com.powsybl.computation.ComputationParameters;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;

public class ComputationParametersImpl
extends AbstractExtendable<ComputationParameters>
implements ComputationParameters {
    private final Map<String, Long> timeoutsByCmdId;
    private final Map<String, Long> deadlinesByCmdId;

    ComputationParametersImpl(Map<String, Long> timeoutsByCommandId, Map<String, Long> deadlinesByCommandId) {
        this.timeoutsByCmdId = Collections.unmodifiableMap(timeoutsByCommandId);
        this.deadlinesByCmdId = Collections.unmodifiableMap(deadlinesByCommandId);
    }

    @Override
    public OptionalLong getTimeout(String commandId) {
        Objects.requireNonNull(commandId);
        Long t = this.timeoutsByCmdId.get(commandId);
        if (t == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(t);
    }

    @Override
    public OptionalLong getDeadline(String commandId) {
        Objects.requireNonNull(commandId);
        Long t = this.deadlinesByCmdId.get(commandId);
        if (t == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(t);
    }
}

