/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.Command;
import java.util.Objects;

public class ExecutionError {
    private final Command command;
    private final int index;
    private final int exitCode;

    public ExecutionError(Command command, int index, int exitCode) {
        Objects.requireNonNull(command);
        if (index < 0) {
            throw new IllegalArgumentException("index < 1");
        }
        this.command = command;
        this.index = index;
        this.exitCode = exitCode;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getIndex() {
        return this.index;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        return this.command.getId() + "[" + this.index + "]=" + this.exitCode;
    }
}

