/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.CompletableFutureTask;
import java.time.ZonedDateTime;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskInterruptionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskInterruptionTest.class);
    public CountDownLatch waitForStart;
    public CountDownLatch waitForEnd;
    public AtomicBoolean config;
    public AtomicBoolean interrupted;

    private void assertions(CompletableFuture<Object> task) throws InterruptedException {
        LOGGER.info("assertions - waitForStart - {}", (Object)ZonedDateTime.now());
        this.waitForStart.await();
        Assertions.assertFalse((boolean)task.isDone());
        LOGGER.info("assertions - cancel - {}", (Object)ZonedDateTime.now());
        boolean cancelled = task.cancel(true);
        LOGGER.info("assertions - isCancelled - {}", (Object)ZonedDateTime.now());
        Assertions.assertTrue((boolean)cancelled);
        Assertions.assertTrue((boolean)task.isCancelled());
        LOGGER.info("assertions - get - {}", (Object)ZonedDateTime.now());
        Assertions.assertFalse((boolean)this.config.get());
        Assertions.assertThrows(CancellationException.class, () -> {
            task.get();
            Assertions.fail((String)"Should not happen: task has been cancelled");
        });
        LOGGER.info("assertions - waitForEnd - {}", (Object)ZonedDateTime.now());
        this.waitUntilTaskEnd(task);
        LOGGER.info("assertions - ended - {}", (Object)ZonedDateTime.now());
        Assertions.assertTrue((boolean)this.interrupted.get());
        cancelled = task.cancel(true);
        Assertions.assertFalse((boolean)cancelled);
    }

    private CompletableFuture<Object> createTask(Supplier<?> methodCalledInTask) {
        return CompletableFutureTask.runAsync(() -> {
            LOGGER.info("createTask - START - {}", (Object)ZonedDateTime.now());
            this.waitForStart.countDown();
            try {
                LOGGER.info("createTask - TRY - {}", (Object)ZonedDateTime.now());
                methodCalledInTask.get();
                LOGGER.info("createTask - FINISHED - {}", (Object)ZonedDateTime.now());
                this.config.set(true);
            }
            catch (Exception e) {
                LOGGER.info("createTask - INTERRUPTED - {}", (Object)ZonedDateTime.now());
                this.interrupted.set(true);
            }
            finally {
                this.waitForEnd.countDown();
            }
            return Boolean.TRUE;
        }, (Executor)Executors.newSingleThreadExecutor());
    }

    public void testCancelLongTask(boolean isDelayed, Supplier<?> methodCalledInTask) throws InterruptedException {
        this.testCancelLongTask(isDelayed ? 2000 : 0, methodCalledInTask);
    }

    public void testCancelLongTask(int delayBeforeInterruption, Supplier<?> methodCalledInTask) throws InterruptedException {
        this.waitForStart = new CountDownLatch(1);
        this.waitForEnd = new CountDownLatch(1);
        this.config = new AtomicBoolean(false);
        this.interrupted = new AtomicBoolean(false);
        CompletableFuture<Object> task = this.createTask(methodCalledInTask);
        if (delayBeforeInterruption > 0) {
            Thread.sleep(delayBeforeInterruption);
        }
        this.assertions(task);
    }

    public void testCancelShortTask(boolean isDelayed, Supplier<?> methodCalledInTask) throws InterruptedException {
        this.waitForStart = new CountDownLatch(1);
        this.waitForEnd = new CountDownLatch(1);
        this.config = new AtomicBoolean(false);
        this.interrupted = new AtomicBoolean(false);
        CompletableFuture<Object> task = this.createTask(methodCalledInTask);
        if (isDelayed) {
            LOGGER.info("shortTask - waitForEnd - {}", (Object)ZonedDateTime.now());
            this.waitUntilTaskEnd(task);
            LOGGER.info("shortTask - ended - {}", (Object)ZonedDateTime.now());
            LOGGER.info("shortTask - cancel task - {}", (Object)ZonedDateTime.now());
            boolean cancelled = task.cancel(true);
            Assertions.assertFalse((boolean)cancelled);
        } else {
            this.assertions(task);
        }
    }

    private void waitUntilTaskEnd(CompletableFuture<Object> task) throws InterruptedException {
        this.waitForEnd.await();
        try {
            task.join();
        }
        catch (CancellationException | CompletionException e) {
            LOGGER.info("Task ended with exception - {}", (Object)ZonedDateTime.now());
            LOGGER.info("{}", (Object)e.getMessage());
        }
    }
}

