/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.ComputationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationExceptionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputationExceptionBuilder.class);
    private String message;
    private final Throwable cause;
    private final Map<String, String> outMsgByLogFileName = new HashMap<String, String>();
    private final Map<String, String> errMsgByLogFileName = new HashMap<String, String>();
    private final Map<String, byte[]> bytesByFileName = new HashMap<String, byte[]>();

    public ComputationExceptionBuilder() {
        this.cause = null;
    }

    public ComputationExceptionBuilder(Throwable cause) {
        this.cause = Objects.requireNonNull(cause);
    }

    public ComputationExceptionBuilder message(@Nullable String message) {
        this.message = message;
        return this;
    }

    public ComputationExceptionBuilder addOutLogIfExists(@Nullable Path path) {
        return this.readFileToMap(path, this.outMsgByLogFileName);
    }

    public ComputationExceptionBuilder addOutLog(String logName, @Nullable String log) {
        Objects.requireNonNull(logName);
        this.outMsgByLogFileName.put(logName, log);
        return this;
    }

    public ComputationExceptionBuilder addErrLogIfExists(@Nullable Path path) {
        return this.readFileToMap(path, this.errMsgByLogFileName);
    }

    public ComputationExceptionBuilder addErrLog(String logName, @Nullable String log) {
        Objects.requireNonNull(logName);
        this.errMsgByLogFileName.put(logName, log);
        return this;
    }

    public ComputationExceptionBuilder addFileIfExists(@Nullable Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return this;
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            this.bytesByFileName.put(path.getFileName().toString(), bytes);
        }
        catch (IOException e) {
            LOGGER.warn("Can not read zip file '{}'", (Object)path);
        }
        return this;
    }

    public ComputationExceptionBuilder addBytes(String key, byte[] bytes) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(key);
        this.bytesByFileName.put(key, bytes);
        return this;
    }

    private ComputationExceptionBuilder readFileToMap(@Nullable Path path, Map<String, String> map) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return this;
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            map.put(path.getFileName().toString(), new String(bytes, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.warn("Can not read log file '{}'", (Object)path);
        }
        return this;
    }

    public ComputationException build() {
        ComputationException exception = this.message != null && this.cause != null ? new ComputationException(this.message, this.cause, this.outMsgByLogFileName, this.errMsgByLogFileName, this.bytesByFileName) : (this.message != null ? new ComputationException(this.message, this.outMsgByLogFileName, this.errMsgByLogFileName, this.bytesByFileName) : (this.cause != null ? new ComputationException(this.cause, this.outMsgByLogFileName, this.errMsgByLogFileName, this.bytesByFileName) : new ComputationException(this.outMsgByLogFileName, this.errMsgByLogFileName, this.bytesByFileName)));
        return exception;
    }
}

