/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;

public class CompletableFutureTask<R>
extends CompletableFuture<R>
implements Runnable {
    private final FutureTask<R> future;

    public CompletableFutureTask(Callable<R> task) {
        this.future = new FutureTask<R>(task);
    }

    @Override
    public void run() {
        this.future.run();
        try {
            this.complete(this.future.get());
        }
        catch (ExecutionException exc) {
            this.completeExceptionally(exc.getCause());
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            this.completeExceptionally(exc);
        }
        catch (Exception exc) {
            this.completeExceptionally(exc);
        }
    }

    public CompletableFutureTask<R> runAsync(Executor executor) {
        executor.execute(this);
        return this;
    }

    public static <T> CompletableFutureTask<T> runAsync(Callable<T> task, Executor executor) {
        return new CompletableFutureTask<T>(task).runAsync(executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return super.cancel(mayInterruptIfRunning) && this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new SourceCancelingCompletableFuture(this);
    }

    static class SourceCancelingCompletableFuture<T>
    extends CompletableFuture<T> {
        private final CompletableFuture<?> source;

        public SourceCancelingCompletableFuture(CompletableFuture<?> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public <U> CompletableFuture<U> newIncompleteFuture() {
            return new SourceCancelingCompletableFuture<T>(this.source);
        }

        @Override
        public boolean cancel(boolean interruptIfRunning) {
            return super.cancel(interruptIfRunning) && this.source.cancel(interruptIfRunning);
        }
    }
}

