/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.base.Preconditions;
import com.powsybl.computation.ComputationParameters;
import com.powsybl.computation.ComputationParametersImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ComputationParametersBuilder {
    private final Map<String, Long> timeoutMap = new HashMap<String, Long>();
    private final Map<String, Long> deadlineMap = new HashMap<String, Long>();

    public ComputationParametersBuilder setTimeout(String cmdId, long seconds) {
        Objects.requireNonNull(cmdId);
        Preconditions.checkArgument((seconds > 0L ? 1 : 0) != 0, (Object)"Timeout must be positive.");
        this.timeoutMap.put(cmdId, seconds);
        return this;
    }

    public ComputationParametersBuilder setDeadline(String cmdId, long seconds) {
        Objects.requireNonNull(cmdId);
        Preconditions.checkArgument((seconds > 0L ? 1 : 0) != 0, (Object)"Deadline must be positive.");
        this.deadlineMap.put(cmdId, seconds);
        return this;
    }

    public ComputationParameters build() {
        return new ComputationParametersImpl(this.timeoutMap, this.deadlineMap);
    }
}

