/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.exceptions.UncheckedClassCastExceptionException;
import com.powsybl.commons.exceptions.UncheckedClassNotFoundException;
import com.powsybl.commons.exceptions.UncheckedIllegalAccessException;
import com.powsybl.commons.exceptions.UncheckedInstantiationException;
import com.powsybl.commons.exceptions.UncheckedInvocationTargetException;
import com.powsybl.commons.exceptions.UncheckedNoSuchMethodException;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.ComputationManagerFactory;
import com.powsybl.computation.LazyCreatedComputationManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComputationManagerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultComputationManagerConfig.class);
    private static final String DEFAULT_SHORT_TIME_EXECUTION_COMPUTATION_MANAGER_FACTORY_CLASS = "com.powsybl.computation.local.LocalComputationManagerFactory";
    private final Class<? extends ComputationManagerFactory> shortTimeExecutionComputationManagerFactoryClass;
    private final Class<? extends ComputationManagerFactory> longTimeExecutionComputationManagerFactoryClass;

    public DefaultComputationManagerConfig(Class<? extends ComputationManagerFactory> shortTimeExecutionComputationManagerFactoryClass, Class<? extends ComputationManagerFactory> longTimeExecutionComputationManagerFactoryClass) {
        this.shortTimeExecutionComputationManagerFactoryClass = Objects.requireNonNull(shortTimeExecutionComputationManagerFactoryClass);
        this.longTimeExecutionComputationManagerFactoryClass = longTimeExecutionComputationManagerFactoryClass;
    }

    public static DefaultComputationManagerConfig load() {
        return DefaultComputationManagerConfig.load(PlatformConfig.defaultConfig());
    }

    public static DefaultComputationManagerConfig load(PlatformConfig platformConfig) {
        Objects.requireNonNull(platformConfig);
        DefaultComputationManagerConfig config = platformConfig.getOptionalModuleConfig("default-computation-manager").map(moduleConfig -> {
            Class shortTimeExecutionComputationManagerFactoryClass = moduleConfig.getClassProperty("short-time-execution-computation-manager-factory", ComputationManagerFactory.class);
            Class longTimeExecutionComputationManagerFactoryClass = moduleConfig.getClassProperty("long-time-execution-computation-manager-factory", ComputationManagerFactory.class, null);
            return new DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass, longTimeExecutionComputationManagerFactoryClass);
        }).orElseGet(() -> {
            Class<?> shortTimeExecutionComputationManagerFactoryClass;
            try {
                shortTimeExecutionComputationManagerFactoryClass = Class.forName(DEFAULT_SHORT_TIME_EXECUTION_COMPUTATION_MANAGER_FACTORY_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedClassNotFoundException(e);
            }
            catch (ClassCastException e) {
                throw new UncheckedClassCastExceptionException(e);
            }
            return new DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass, null);
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(config.toString());
        }
        return config;
    }

    private ComputationManager createComputationManager(Class<? extends ComputationManagerFactory> computationManagerFactoryClass) {
        try {
            return new LazyCreatedComputationManager(computationManagerFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw new UncheckedInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedIllegalAccessException(e);
        }
        catch (NoSuchMethodException e) {
            throw new UncheckedNoSuchMethodException(e);
        }
        catch (InvocationTargetException e) {
            throw new UncheckedInvocationTargetException(e);
        }
    }

    public ComputationManager createShortTimeExecutionComputationManager() {
        return this.createComputationManager(this.shortTimeExecutionComputationManagerFactoryClass);
    }

    public ComputationManager createLongTimeExecutionComputationManager() {
        return this.longTimeExecutionComputationManagerFactoryClass == null ? this.createShortTimeExecutionComputationManager() : this.createComputationManager(this.longTimeExecutionComputationManagerFactoryClass);
    }

    public String toString() {
        String str = "DefaultComputationManagerConfig(shortTimeExecutionComputationManagerFactoryClass=" + this.shortTimeExecutionComputationManagerFactoryClass.getName() + ", longTimeExecutionComputationManagerFactoryClass=";
        str = str + Objects.requireNonNullElse(this.longTimeExecutionComputationManagerFactoryClass, this.shortTimeExecutionComputationManagerFactoryClass).getName();
        str = str + ")";
        return str;
    }
}

