/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.FileName;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class FunctionFileName
implements FileName {
    private final Function<Integer, String> nameFunc;
    private final Consumer<String> validator;

    public FunctionFileName(Function<Integer, String> nameFunc, Consumer<String> validator) {
        this.nameFunc = Objects.requireNonNull(nameFunc);
        this.validator = validator;
    }

    @Override
    public String getName(int executionNumber) {
        String name = this.nameFunc.apply(executionNumber);
        if (this.validator != null) {
            this.validator.accept(name);
        }
        return name;
    }

    @Override
    public boolean dependsOnExecutionNumber() {
        return true;
    }
}

