/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.collect.ImmutableList;
import com.powsybl.computation.AbstractCommand;
import com.powsybl.computation.CommandType;
import com.powsybl.computation.GroupCommand;
import com.powsybl.computation.InputFile;
import com.powsybl.computation.OutputFile;
import java.util.List;
import java.util.function.Function;

class GroupCommandImpl
extends AbstractCommand
implements GroupCommand {
    private final List<GroupCommand.SubCommand> subCommands;

    GroupCommandImpl(String id, List<GroupCommand.SubCommand> subCommands, List<InputFile> inputFiles, List<OutputFile> outputFiles) {
        super(id, inputFiles, outputFiles);
        this.subCommands = subCommands;
    }

    @Override
    public List<GroupCommand.SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public CommandType getType() {
        return CommandType.GROUP;
    }

    @Override
    public String toString(int executionNumber) {
        return this.subCommands.stream().map(subCommand -> subCommand.toString(executionNumber)).toList().toString();
    }

    static class SubCommandImpl
    implements GroupCommand.SubCommand {
        private final String program;
        private final Function<Integer, List<String>> args;
        private final int timeout;

        SubCommandImpl(String program, Function<Integer, List<String>> args, int timeout) {
            this.program = program;
            this.args = args;
            this.timeout = timeout;
        }

        @Override
        public String getProgram() {
            return this.program;
        }

        @Override
        public List<String> getArgs(int executionNumber) {
            return this.args.apply(executionNumber);
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public String toString(int executionNumber) {
            return ImmutableList.builder().add((Object)this.program).addAll(this.getArgs(executionNumber)).build().toString();
        }
    }
}

