/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.FileName;
import com.powsybl.computation.FilePreProcessor;
import com.powsybl.computation.FunctionFileName;
import com.powsybl.computation.StringFileName;
import java.io.File;
import java.util.Objects;
import java.util.function.Function;

public class InputFile {
    private final FileName name;
    private final FilePreProcessor preProcessor;

    public InputFile(String name) {
        this(name, null);
    }

    public InputFile(String name, FilePreProcessor preProcessor) {
        this.name = new StringFileName(InputFile.checkName(name, preProcessor));
        this.preProcessor = preProcessor;
    }

    public InputFile(Function<Integer, String> nameFunc, FilePreProcessor preProcessor) {
        this.name = new FunctionFileName(nameFunc, fileName -> InputFile.checkName(fileName, preProcessor));
        this.preProcessor = preProcessor;
    }

    public static String checkName(String name, FilePreProcessor preProcessor) {
        Objects.requireNonNull(name, "name is null");
        if (name.contains(File.separator)) {
            throw new IllegalArgumentException("input file name must not contain directory path");
        }
        if (preProcessor != null) {
            switch (preProcessor) {
                case FILE_GUNZIP: {
                    if (name.endsWith(".gz")) break;
                    throw new IllegalArgumentException(name + " is expected to end with .gz");
                }
                case ARCHIVE_UNZIP: {
                    if (name.endsWith(".zip")) break;
                    throw new IllegalArgumentException(name + " is expected to end with .zip");
                }
                default: {
                    throw new IllegalStateException("Unexpected FilePreProcessor value: " + preProcessor);
                }
            }
        }
        return name;
    }

    public String getName(int executionNumber) {
        return this.name.getName(executionNumber);
    }

    public FilePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public boolean dependsOnExecutionNumber() {
        return this.name.dependsOnExecutionNumber();
    }
}

