/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.re2j.Pattern;
import com.powsybl.commons.PowsyblException;
import java.util.Objects;

public class Partition {
    private static final Pattern PATTERN = Pattern.compile((String)"^\\d+/\\d+$");
    private final int taskIndex;
    private final int taskCount;

    public static Partition parse(String partition) {
        Objects.requireNonNull(partition);
        boolean valid = PATTERN.matcher((CharSequence)partition).find();
        if (!valid) {
            throw new PowsyblException(partition + " is not valid");
        }
        String[] split = partition.split("/");
        int taskIndex = Integer.parseInt(split[0]);
        int taskCount = Integer.parseInt(split[1]);
        return new Partition(taskIndex, taskCount);
    }

    public Partition(int taskIndex, int taskCount) {
        if (taskIndex > taskCount || taskIndex < 1) {
            throw new PowsyblException(Partition.toString(taskIndex, taskCount) + " is not valid");
        }
        this.taskIndex = taskIndex;
        this.taskCount = taskCount;
    }

    public int startIndex(int size) {
        this.checkSize(size);
        return (this.taskIndex - 1) * size / this.taskCount;
    }

    public int endIndex(int size) {
        this.checkSize(size);
        return this.taskIndex * size / this.taskCount;
    }

    private void checkSize(int size) {
        if (size != 0 && size < this.taskCount) {
            throw new PowsyblException("Data size must be greater than task count");
        }
    }

    public String toString() {
        return Partition.toString(this.taskIndex, this.taskCount);
    }

    private static String toString(int taskIndex, int taskCount) {
        return Integer.toString(taskIndex) + "/" + taskCount;
    }
}

