/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.commons.PowsyblException;
import com.powsybl.computation.AbstractCommandBuilder;
import com.powsybl.computation.SimpleCommand;
import com.powsybl.computation.SimpleCommandImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SimpleCommandBuilder
extends AbstractCommandBuilder<SimpleCommandBuilder> {
    private String program;
    private Function<Integer, List<String>> args = executionNumber -> Collections.emptyList();
    private int timeout = -1;

    public SimpleCommandBuilder program(String program) {
        this.program = program;
        return this;
    }

    public SimpleCommandBuilder args(Function<Integer, List<String>> args) {
        this.args = Objects.requireNonNull(args);
        return this;
    }

    public SimpleCommandBuilder args(List<String> args) {
        Objects.requireNonNull(args);
        this.args = executionNumber -> args.stream().map(arg -> arg.replace("${EXEC_NUM}", executionNumber.toString())).collect(Collectors.toList());
        return this;
    }

    public SimpleCommandBuilder args(String ... args) {
        Objects.requireNonNull(args);
        this.args(Arrays.asList(args));
        return this;
    }

    public SimpleCommandBuilder arg(String arg) {
        Objects.requireNonNull(this.args);
        this.arg((Integer i) -> arg);
        return this;
    }

    public SimpleCommandBuilder arg(Function<Integer, String> arg) {
        Objects.requireNonNull(arg);
        Function<Integer, List<String>> previous = this.args;
        this.args = i -> {
            ArrayList<String> r = new ArrayList<String>((Collection)previous.apply((Integer)i));
            r.add((String)arg.apply((Integer)i));
            return r;
        };
        return this;
    }

    public SimpleCommandBuilder flag(String flagName, boolean flagValue) {
        Objects.requireNonNull(flagName);
        if (flagValue) {
            this.arg("--" + flagName);
        }
        return this;
    }

    public SimpleCommandBuilder option(String opt, String value) {
        Objects.requireNonNull(opt);
        Objects.requireNonNull(value);
        this.arg("--" + opt + "=" + value);
        return this;
    }

    public SimpleCommandBuilder option(String opt, Function<Integer, String> fn) {
        Objects.requireNonNull(opt);
        Objects.requireNonNull(fn);
        this.arg((Integer i) -> "--" + opt + "=" + (String)fn.apply((Integer)i));
        return this;
    }

    public SimpleCommandBuilder timeout(int timeout) {
        this.timeout = timeout;
        if (timeout < -1 || timeout == 0) {
            throw new PowsyblException("invalid timeout");
        }
        return this;
    }

    public SimpleCommand build() {
        if (this.id == null) {
            throw new PowsyblException("id is not set");
        }
        if (this.program == null) {
            throw new PowsyblException("program is not set");
        }
        return new SimpleCommandImpl(this.id, this.program, this.args, this.timeout, this.inputFiles, this.outputFiles);
    }
}

