/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.powsybl.computation.FileName;
import java.util.Objects;

public class StringFileName
implements FileName {
    private final String name;

    public StringFileName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    private static String executionNumberToString(int executionNumber) {
        return executionNumber == -1 ? "*" : Integer.toString(executionNumber);
    }

    @Override
    public String getName(int executionNumber) {
        return this.name.replace("${EXEC_NUM}", StringFileName.executionNumberToString(executionNumber));
    }

    @Override
    public boolean dependsOnExecutionNumber() {
        return this.name.contains("${EXEC_NUM}");
    }
}

