/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import com.google.common.collect.ImmutableList;
import com.powsybl.computation.AbstractCommand;
import com.powsybl.computation.CommandType;
import com.powsybl.computation.InputFile;
import com.powsybl.computation.OutputFile;
import com.powsybl.computation.SimpleCommand;
import java.util.List;
import java.util.function.Function;

class SimpleCommandImpl
extends AbstractCommand
implements SimpleCommand {
    private final String program;
    private final Function<Integer, List<String>> args;

    SimpleCommandImpl(String id, String program, Function<Integer, List<String>> args, List<InputFile> inputFiles, List<OutputFile> outputFiles) {
        super(id, inputFiles, outputFiles);
        this.program = program;
        this.args = args;
    }

    @Override
    public CommandType getType() {
        return CommandType.SIMPLE;
    }

    @Override
    public String getProgram() {
        return this.program;
    }

    @Override
    public List<String> getArgs(int executionNumber) {
        return this.args.apply(executionNumber);
    }

    @Override
    public String toString(int executionNumber) {
        return ImmutableList.builder().add((Object)this.program).addAll(this.getArgs(executionNumber)).build().toString();
    }
}

