/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.computation;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadInterruptedCompletableFuture<R>
extends CompletableFuture<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadInterruptedCompletableFuture.class);
    protected volatile boolean cancel = false;
    protected Thread thread;

    public void setThread(Thread t) {
        this.thread = Objects.requireNonNull(t);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancel = true;
        if (this.isDone() || this.isCompletedExceptionally()) {
            LOGGER.warn("Cannot be canceled because the caller future isDone or isCompletedExceptionally");
            return false;
        }
        while (this.thread == null) {
            try {
                LOGGER.warn("Waiting 1s for taskThread to be set...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.toString(), (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        this.thread.interrupt();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }
}

